<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

$laundrycity_blog_style = explode('_', laundrycity_get_theme_option('blog_style'));
$laundrycity_columns = empty($laundrycity_blog_style[1]) ? 2 : max(2, $laundrycity_blog_style[1]);
$laundrycity_expanded = !laundrycity_sidebar_present() && laundrycity_is_on(laundrycity_get_theme_option('expand_content'));
$laundrycity_post_format = get_post_format();
$laundrycity_post_format = empty($laundrycity_post_format) ? 'standard' : str_replace('post-format-', '', $laundrycity_post_format);
$laundrycity_animation = laundrycity_get_theme_option('blog_animation');

?><div class="<?php echo esc_attr($laundrycity_blog_style[0]) == 'classic' ? 'column' : 'masonry_item masonry_item'; ?>-1_<?php echo esc_attr($laundrycity_columns); ?>"><article id="post-<?php the_ID(); ?>"
	<?php post_class( 'post_item post_format_'.esc_attr($laundrycity_post_format)
					. ' post_layout_classic post_layout_classic_'.esc_attr($laundrycity_columns)
					. ' post_layout_'.esc_attr($laundrycity_blog_style[0]) 
					. ' post_layout_'.esc_attr($laundrycity_blog_style[0]).'_'.esc_attr($laundrycity_columns)
					); ?>
	<?php echo (!laundrycity_is_off($laundrycity_animation) ? ' data-animation="'.esc_attr(laundrycity_get_animation_classes($laundrycity_animation)).'"' : ''); ?>
	>

	<?php

	// Featured image
	laundrycity_show_post_featured( array( 'thumb_size' => laundrycity_get_thumb_size($laundrycity_blog_style[0] == 'classic'
													? (strpos(laundrycity_get_theme_option('body_style'), 'full')!==false 
															? ( $laundrycity_columns > 2 ? 'big' : 'huge' )
															: (	$laundrycity_columns > 2
																? ($laundrycity_expanded ? 'med' : 'small')
																: ($laundrycity_expanded ? 'big' : 'med')
																)
														)
													: (strpos(laundrycity_get_theme_option('body_style'), 'full')!==false 
															? ( $laundrycity_columns > 2 ? 'masonry-big' : 'full' )
															: (	$laundrycity_columns <= 2 && $laundrycity_expanded ? 'masonry-big' : 'masonry')
														)
								) ) );

	if ( !in_array($laundrycity_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			do_action('laundrycity_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );

			do_action('laundrycity_action_before_post_meta'); 

			// Post meta
			laundrycity_show_post_meta(array(
				'categories' => true,
				'date' => true,
				'edit' => $laundrycity_columns < 3,
				'seo' => false,
				'share' => false,
				'counters' => 'comments',
				)
			);
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$laundrycity_show_learn_more = false;
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($laundrycity_post_format, array('link', 'aside', 'status', 'quote'))) {
				the_content();
			} else if (substr(get_the_content(), 0, 1)!='[') {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($laundrycity_post_format, array('link', 'aside', 'status', 'quote'))) {
			laundrycity_show_post_meta(array(
				'share' => false,
				'counters' => 'comments'
				)
			);
		}
		// More button
		if ( $laundrycity_show_learn_more ) {
			?><p><a class="more-link" href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('Read more', 'laundrycity'); ?></a></p><?php
		}
		?>
	</div><!-- .entry-content -->

</article></div>