<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

$laundrycity_blog_style = explode('_', laundrycity_get_theme_option('blog_style'));
$laundrycity_columns = empty($laundrycity_blog_style[1]) ? 1 : max(1, $laundrycity_blog_style[1]);
$laundrycity_expanded = !laundrycity_sidebar_present() && laundrycity_is_on(laundrycity_get_theme_option('expand_content'));
$laundrycity_post_format = get_post_format();
$laundrycity_post_format = empty($laundrycity_post_format) ? 'standard' : str_replace('post-format-', '', $laundrycity_post_format);
$laundrycity_animation = laundrycity_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($laundrycity_columns).' post_format_'.esc_attr($laundrycity_post_format) ); ?>
	<?php echo (!laundrycity_is_off($laundrycity_animation) ? ' data-animation="'.esc_attr(laundrycity_get_animation_classes($laundrycity_animation)).'"' : ''); ?>
	>

	<?php
	// Add anchor
	if ($laundrycity_columns == 1 && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="'.esc_attr(get_the_title()).'"]');
	}

	// Featured image
	laundrycity_show_post_featured( array(
											'class' => $laundrycity_columns == 1 ? 'trx-stretch-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => laundrycity_get_thumb_size(
																	strpos(laundrycity_get_theme_option('body_style'), 'full')!==false
																		? ( $laundrycity_columns > 1 ? 'huge' : 'original' )
																		: (	$laundrycity_columns > 2 ? 'big' : 'huge')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			do_action('laundrycity_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			
			do_action('laundrycity_action_before_post_meta'); 

			// Post meta
			$laundrycity_post_meta = laundrycity_show_post_meta(array(
									'categories' => true,
									'date' => true,
									'edit' => $laundrycity_columns == 1,
									'seo' => false,
									'share' => false,
									'counters' => $laundrycity_columns < 3 ? 'comments' : '',
									'echo' => false
									)
								);
			laundrycity_show_layout($laundrycity_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$laundrycity_show_learn_more = !in_array($laundrycity_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($laundrycity_post_format, array('link', 'aside', 'status', 'quote'))) {
					the_content();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($laundrycity_post_format, array('link', 'aside', 'status', 'quote'))) {
				laundrycity_show_layout($laundrycity_post_meta);
			}
			// More button
			if ( $laundrycity_show_learn_more ) {
				?><p><a class="more-link" href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('Read more', 'laundrycity'); ?></a></p><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>