<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage LAUNDRYCITY
 * @since LAUNDRYCITY 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the Visual Composer to make custom page layout:
 * just insert %%CONTENT%% in the desired place of content
 */

// Get template page's content
$laundrycity_content = '';
$laundrycity_blog_archive_mask = '%%CONTENT%%';
$laundrycity_blog_archive_subst = sprintf('<div class="blog_archive">%s</div>', $laundrycity_blog_archive_mask);
if ( have_posts() ) {
	the_post(); 
	if (($laundrycity_content = apply_filters('the_content', get_the_content())) != '') {
		if (($laundrycity_pos = strpos($laundrycity_content, $laundrycity_blog_archive_mask)) !== false) {
			$laundrycity_content = preg_replace('/(\<p\>\s*)?'.$laundrycity_blog_archive_mask.'(\s*\<\/p\>)/i', $laundrycity_blog_archive_subst, $laundrycity_content);
		} else
			$laundrycity_content .= $laundrycity_blog_archive_subst;
		$laundrycity_content = explode($laundrycity_blog_archive_mask, $laundrycity_content);
	}
}

// Prepare args for a new query
$laundrycity_args = array(
	'post_status' => current_user_can('read_private_pages') && current_user_can('read_private_posts') ? array('publish', 'private') : 'publish'
);
$laundrycity_args = laundrycity_query_add_posts_and_cats($laundrycity_args, '', laundrycity_get_theme_option('post_type'), laundrycity_get_theme_option('parent_cat'));
$laundrycity_page_number = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
if ($laundrycity_page_number > 1) {
	$laundrycity_args['paged'] = $laundrycity_page_number;
	$laundrycity_args['ignore_sticky_posts'] = true;
}
$laundrycity_ppp = laundrycity_get_theme_option('posts_per_page');
if ((int) $laundrycity_ppp != 0)
	$laundrycity_args['posts_per_page'] = (int) $laundrycity_ppp;
// Make a new query
query_posts( $laundrycity_args );
// Set a new query as main WP Query
$GLOBALS['wp_the_query'] = $GLOBALS['wp_query'];

// Set query vars in the new query!
if (is_array($laundrycity_content) && count($laundrycity_content) == 2) {
	set_query_var('blog_archive_start', $laundrycity_content[0]);
	set_query_var('blog_archive_end', $laundrycity_content[1]);
}

get_template_part('index');
?>