<?php

if ( ! function_exists( 'justicia_mikado_dropdown_cart_icon_styles' ) ) {
	/**
	 * Generates styles for dropdown cart icon
	 */
	function justicia_mikado_dropdown_cart_icon_styles() {
		$icon_color       = justicia_mikado_options()->getOptionValue( 'dropdown_cart_icon_color' );
		$icon_hover_color = justicia_mikado_options()->getOptionValue( 'dropdown_cart_hover_color' );
		
		if ( ! empty( $icon_color ) ) {
			echo justicia_mikado_dynamic_css( '.mkdf-shopping-cart-holder .mkdf-header-cart a', array( 'color' => $icon_color ) );
		}
		
		if ( ! empty( $icon_hover_color ) ) {
			echo justicia_mikado_dynamic_css( '.mkdf-shopping-cart-holder .mkdf-header-cart a:hover', array( 'color' => $icon_hover_color ) );
		}
	}
	
	add_action( 'justicia_mikado_action_style_dynamic', 'justicia_mikado_dropdown_cart_icon_styles' );
}