<?php

if ( ! function_exists( 'justicia_mikado_map_woocommerce_meta' ) ) {
	function justicia_mikado_map_woocommerce_meta() {
		
		$woocommerce_meta_box = justicia_mikado_create_meta_box(
			array(
				'scope' => array( 'product' ),
				'title' => esc_html__( 'Product Meta', 'justicia' ),
				'name'  => 'woo_product_meta'
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_product_featured_image_size',
				'type'        => 'select',
				'label'       => esc_html__( 'Dimensions for Product List Shortcode', 'justicia' ),
				'description' => esc_html__( 'Choose image layout when it appears in Mikado Product List - Masonry layout shortcode', 'justicia' ),
				'options'     => array(
					''                   => esc_html__( 'Default', 'justicia' ),
					'small'              => esc_html__( 'Small', 'justicia' ),
					'large-width'        => esc_html__( 'Large Width', 'justicia' ),
					'large-height'       => esc_html__( 'Large Height', 'justicia' ),
					'large-width-height' => esc_html__( 'Large Width Height', 'justicia' )
				),
				'parent'      => $woocommerce_meta_box
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_show_title_area_woo_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'justicia' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'justicia' ),
				'options'       => justicia_mikado_get_yes_no_select_array(),
				'parent'        => $woocommerce_meta_box
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_show_new_sign_woo_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Show New Sign', 'justicia' ),
				'description'   => esc_html__( 'Enabling this option will show new sign mark on product', 'justicia' ),
				'parent'        => $woocommerce_meta_box
			)
		);
	}
	
	add_action( 'justicia_mikado_action_meta_boxes_map', 'justicia_mikado_map_woocommerce_meta', 99 );
}