<?php

if ( class_exists( 'JusticiaCoreClassWidget' ) ) {
    class JusticiaMikadoClassVerticalTimelineWidget extends JusticiaCoreClassWidget {
        public function __construct() {
            parent::__construct(
                'mkdf_vertical_timeline_widget',
                esc_html__( 'Justicia Vertical Timeline Widget', 'justicia' ),
                array( 'description' => esc_html__( 'Add vertical timeline element to widget areas', 'justicia' ) )
            );

            $this->setParams();
        }

        protected function setParams() {
            $items_array = array();
            for ($i = 1; $i <= 5; $i++) {
                $items_array[] = array(
                    'type'    => 'textfield',
                    'name'    => 'timeline_item_'.$i.'_year',
                    'title'   => esc_html__( 'Item Year '.$i, 'justicia' )
                );

                $items_array[] = array(
                    'type'    => 'textfield',
                    'name'    => 'timeline_item_'.$i.'_title',
                    'title'   => esc_html__( 'Item Title '.$i, 'justicia' )
                );

                $items_array[] = array(
                    'type'    => 'textfield',
                    'name'    => 'timeline_item_'.$i.'_text',
                    'title'   => esc_html__( 'Item Text '.$i, 'justicia' )
                );
            }

            $this->params = array_merge(
                array(
                    array(
                        'type'    => 'textfield',
                        'name'    => 'title',
                        'title'   => esc_html__( 'Title', 'justicia' )
                    ),
                    array(
                        'type'    => 'dropdown',
                        'name'    => 'title_tag',
                        'title'   => esc_html__( 'Title Tag', 'justicia' ),
                        'options' => justicia_mikado_get_title_tag( true ),
                    ),
                    array(
                        'type'    => 'dropdown',
                        'name'    => 'items_title_tag',
                        'title'   => esc_html__( 'Timeline Items Title Tag', 'justicia' ),
                        'options' => justicia_mikado_get_title_tag( true ),
                    ),
                    array(
                        'type'  => 'textfield',
                        'name'  => 'link',
                        'title' => esc_html__( 'Link', 'justicia' )
                    ),
                    array(
                        'type'    => 'textfield',
                        'name'    => 'link_text',
                        'title'   => esc_html__( 'Link Text', 'justicia' )
                    ),
                    array(
                        'type'    => 'dropdown',
                        'name'    => 'link_target',
                        'title'   => esc_html__( 'Link Target', 'justicia' ),
                        'options' => justicia_mikado_get_link_target_array()
                    )
                ),
                $items_array
            );
        }

        public function widget( $args, $instance ) {
            $params = '';
            $timeline_items = array();

            if ( ! is_array( $instance ) ) {
                $instance = array();
            }

            // Filter out all empty params
            $instance = array_filter( $instance, function ( $array_value ) {
                return trim( $array_value ) != '';
            } );



            // Generate shortcode params
            foreach ( $instance as $key => $value ) {
                if (strpos($key, 'timeline_item') !== false){
                    //get key and name to be properly added to items array
                    $new_key = substr($key,strlen('timeline_item_'), 1) - 1;
                    $name = substr($key,strlen('timeline_item_1_'));

                    $timeline_items[$new_key][$name] = $value;
                } else {
                    $params .= " $key='$value' ";
                }
            }

            //add timeline items in correct form
            $params .= " timeline_items='".urlencode( json_encode( $timeline_items ))."' ";

            echo '<div class="widget mkdf-vertical-timeline-widget">';
            echo do_shortcode( "[mkdf_vertical_timeline $params]" ); // XSS OK
            echo '</div>';
        }
    }
}