<?php

if ( class_exists( 'JusticiaCoreClassWidget' ) ) {
    class JusticiaMikadoClassSeparatorWidget extends JusticiaCoreClassWidget {
        public function __construct() {
            parent::__construct(
                'mkdf_separator_widget',
                esc_html__( 'Justicia Separator Widget', 'justicia' ),
                array( 'description' => esc_html__( 'Add a separator element to your widget areas', 'justicia' ) )
            );

            $this->setParams();
        }

        protected function setParams() {
            $this->params = array(
                array(
                    'type'    => 'dropdown',
                    'name'    => 'type',
                    'title'   => esc_html__( 'Type', 'justicia' ),
                    'options' => array(
                        'normal'     => esc_html__( 'Normal', 'justicia' ),
                        'full-width' => esc_html__( 'Full Width', 'justicia' )
                    )
                ),
                array(
                    'type'    => 'dropdown',
                    'name'    => 'position',
                    'title'   => esc_html__( 'Position', 'justicia' ),
                    'options' => array(
                        'center' => esc_html__( 'Center', 'justicia' ),
                        'left'   => esc_html__( 'Left', 'justicia' ),
                        'right'  => esc_html__( 'Right', 'justicia' )
                    )
                ),
                array(
                    'type'    => 'dropdown',
                    'name'    => 'border_style',
                    'title'   => esc_html__( 'Style', 'justicia' ),
                    'options' => array(
                        'solid'  => esc_html__( 'Solid', 'justicia' ),
                        'dashed' => esc_html__( 'Dashed', 'justicia' ),
                        'dotted' => esc_html__( 'Dotted', 'justicia' )
                    )
                ),
                array(
                    'type'  => 'colorpicker',
                    'name'  => 'color',
                    'title' => esc_html__( 'Color', 'justicia' )
                ),
                array(
                    'type'  => 'textfield',
                    'name'  => 'width',
                    'title' => esc_html__( 'Width (px or %)', 'justicia' )
                ),
                array(
                    'type'  => 'textfield',
                    'name'  => 'thickness',
                    'title' => esc_html__( 'Thickness (px)', 'justicia' )
                ),
                array(
                    'type'  => 'textfield',
                    'name'  => 'top_margin',
                    'title' => esc_html__( 'Top Margin (px or %)', 'justicia' )
                ),
                array(
                    'type'  => 'textfield',
                    'name'  => 'bottom_margin',
                    'title' => esc_html__( 'Bottom Margin (px or %)', 'justicia' )
                )
            );
        }

        public function widget( $args, $instance ) {
            if ( ! is_array( $instance ) ) {
                $instance = array();
            }

            //prepare variables
            $params = '';

            //is instance empty?
            if ( is_array( $instance ) && count( $instance ) ) {
                //generate shortcode params
                foreach ( $instance as $key => $value ) {
                    $params .= " $key='$value' ";
                }
            }

            echo '<div class="widget mkdf-separator-widget">';
            echo do_shortcode( "[mkdf_separator $params]" ); // XSS OK
            echo '</div>';
        }
    }
}