<?php

if ( class_exists( 'JusticiaCoreClassWidget' ) ) {
    class JusticiaMikadoClassPortfolioListWidget extends JusticiaCoreClassWidget {
        public function __construct() {
            parent::__construct(
                'mkdf_portfolio_list_widget',
                esc_html__( 'Justicia Portfolio List Widget', 'justicia' ),
                array( 'description' => esc_html__( 'Display a list of your portfolio', 'justicia' ) )
            );

            $this->setParams();
        }

        protected function setParams() {
            $this->params = array(

                array(
                    'type'  => 'textfield',
                    'name'  => 'widget_title',
                    'title' => esc_html__( 'Widget Title', 'justicia' )
                ),
                array(
                    'type'  => 'textfield',
                    'name'  => 'widget_title_bottom_margin',
                    'title' => esc_html__( 'Widget Title Bottom Margin (px)', 'justicia' )
                ),


                array(
                    'type'  => 'textfield',
                    'name'  => 'number_of_items',
                    'title' => esc_html__( 'Number of Portfolio', 'justicia' )
                ),
                array(
                    'type'    => 'dropdown',
                    'name'    => 'space_between_items',
                    'title'   => esc_html__( 'Space Between Items', 'justicia' ),
                    'options' => justicia_mikado_get_space_between_items_array()
                ),
                array(
                    'type'    => 'dropdown',
                    'name'    => 'orderby',
                    'title'   => esc_html__( 'Order By', 'justicia' ),
                    'options' => justicia_mikado_get_query_order_by_array()
                ),
                array(
                    'type'    => 'dropdown',
                    'name'    => 'order',
                    'title'   => esc_html__( 'Order', 'justicia' ),
                    'options' => justicia_mikado_get_query_order_array()
                ),
                array(
                    'type'        => 'textfield',
                    'name'        => 'category',
                    'title'       => esc_html__( 'Category Slug', 'justicia' ),
                    'description' => esc_html__( 'Leave empty for all or use comma for list', 'justicia' )
                ),

            );
        }

        public function widget( $args, $instance ) {
            if ( ! is_array( $instance ) ) {
                $instance = array();
            }

            $instance['image_size']        = 'thumbnail';
            $instance['post_info_section'] = 'yes';
            $instance['number_of_columns'] = 'one';

            // Filter out all empty params
            $instance         = array_filter( $instance, function ( $array_value ) {
                return trim( $array_value ) != '';
            } );
            $instance['type'] = ! empty( $instance['type'] ) ? $instance['type'] : 'minimal';

            $params = '';
            //generate shortcode params
            foreach ( $instance as $key => $value ) {
                $params .= " $key='$value' ";
            }

            $widget_styles = array();
            if ( isset( $instance['widget_bottom_margin'] ) && $instance['widget_bottom_margin'] !== '' ) {
                $widget_styles[] = 'margin-bottom: ' . justicia_mikado_filter_px( $instance['widget_bottom_margin'] ) . 'px';
            }

            $widget_title_styles = array();
            if ( isset( $instance['widget_title_bottom_margin'] ) && $instance['widget_title_bottom_margin'] !== '' ) {
                $widget_title_styles[] = 'margin-bottom: ' . justicia_mikado_filter_px( $instance['widget_title_bottom_margin'] ) . 'px';
            }

            echo '<div class="widget mkdf-portfolio-list-widget" ' . justicia_mikado_get_inline_style( $widget_styles ) . '>';
            if ( ! empty( $instance['widget_title'] ) ) {
                if ( ! empty( $widget_title_styles ) ) {
                    $args['before_title'] = justicia_mikado_widget_modified_before_title( $args['before_title'], $widget_title_styles ) ;
                }

                echo wp_kses_post( $args['before_title'] ) . esc_html( $instance['widget_title'] ) . wp_kses_post( $args['after_title'] );
            }

            echo do_shortcode( "[mkdf_portfolio_list $params]" ); // XSS OK
            echo '</div>';
        }
    }
}