<?php

if ( class_exists( 'JusticiaCoreClassWidget' ) ) {
    class JusticiaMikadoClassButtonWidget extends JusticiaCoreClassWidget {
        public function __construct() {
            parent::__construct(
                'mkdf_button_widget',
                esc_html__( 'Justicia Button Widget', 'justicia' ),
                array( 'description' => esc_html__( 'Add button element to widget areas', 'justicia' ) )
            );

            $this->setParams();
        }

        protected function setParams() {
            $this->params = array(
                array(
                    'type'    => 'dropdown',
                    'name'    => 'type',
                    'title'   => esc_html__( 'Type', 'justicia' ),
                    'options' => array(
                        'solid'   => esc_html__( 'Solid', 'justicia' ),
                        'outline' => esc_html__( 'Outline', 'justicia' ),
                        'simple'  => esc_html__( 'Simple', 'justicia' )
                    )
                ),
                array(
                    'type'        => 'dropdown',
                    'name'        => 'size',
                    'title'       => esc_html__( 'Size', 'justicia' ),
                    'options'     => array(
                        'small'  => esc_html__( 'Small', 'justicia' ),
                        'medium' => esc_html__( 'Medium', 'justicia' ),
                        'large'  => esc_html__( 'Large', 'justicia' ),
                        'huge'   => esc_html__( 'Huge', 'justicia' )
                    ),
                    'description' => esc_html__( 'This option is only available for solid and outline button type', 'justicia' )
                ),
                array(
                    'type'    => 'textfield',
                    'name'    => 'text',
                    'title'   => esc_html__( 'Text', 'justicia' ),
                    'default' => esc_html__( 'Button Text', 'justicia' )
                ),
                array(
                    'type'  => 'textfield',
                    'name'  => 'link',
                    'title' => esc_html__( 'Link', 'justicia' )
                ),
                array(
                    'type'    => 'dropdown',
                    'name'    => 'target',
                    'title'   => esc_html__( 'Link Target', 'justicia' ),
                    'options' => justicia_mikado_get_link_target_array()
                ),

                array(
                    'type'  => 'textfield',
                    'name'  => 'font_size',
                    'title' => esc_html__( 'Font Size (px)', 'justicia' )
                ),

                array(
                    'type'  => 'colorpicker',
                    'name'  => 'color',
                    'title' => esc_html__( 'Color', 'justicia' )
                ),
                array(
                    'type'  => 'colorpicker',
                    'name'  => 'hover_color',
                    'title' => esc_html__( 'Hover Color', 'justicia' )
                ),
                array(
                    'type'        => 'colorpicker',
                    'name'        => 'background_color',
                    'title'       => esc_html__( 'Background Color', 'justicia' ),
                    'description' => esc_html__( 'This option is only available for solid button type', 'justicia' )
                ),
                array(
                    'type'        => 'colorpicker',
                    'name'        => 'hover_background_color',
                    'title'       => esc_html__( 'Hover Background Color', 'justicia' ),
                    'description' => esc_html__( 'This option is only available for solid button type', 'justicia' )
                ),
                array(
                    'type'        => 'colorpicker',
                    'name'        => 'border_color',
                    'title'       => esc_html__( 'Border Color', 'justicia' ),
                    'description' => esc_html__( 'This option is only available for solid and outline button type', 'justicia' )
                ),
                array(
                    'type'        => 'colorpicker',
                    'name'        => 'hover_border_color',
                    'title'       => esc_html__( 'Hover Border Color', 'justicia' ),
                    'description' => esc_html__( 'This option is only available for solid and outline button type', 'justicia' )
                ),
                array(
                    'type'        => 'textfield',
                    'name'        => 'margin',
                    'title'       => esc_html__( 'Margin', 'justicia' ),
                    'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'justicia' )
                )
            );
        }

        public function widget( $args, $instance ) {
            $params = '';

            if ( ! is_array( $instance ) ) {
                $instance = array();
            }

            // Filter out all empty params
            $instance = array_filter( $instance, function ( $array_value ) {
                return trim( $array_value ) != '';
            } );

            // Default values
            if ( ! isset( $instance['text'] ) ) {
                $instance['text'] = 'Button Text';
            }

            // Generate shortcode params
            foreach ( $instance as $key => $value ) {
                $params .= " $key='$value' ";
            }

            echo '<div class="widget mkdf-button-widget">';
            echo do_shortcode( "[mkdf_button $params]" ); // XSS OK
            echo '</div>';
        }
    }
}