<?php

/**
 * Force Visual Composer to initialize as "built into the theme". This will hide certain tabs under the Settings->Visual Composer page
 */
if ( function_exists( 'vc_set_as_theme' ) ) {
	vc_set_as_theme( true );
}

/**
 * Change path for overridden templates
 */
if ( function_exists( 'vc_set_shortcodes_templates_dir' ) ) {
	$dir = MIKADO_ROOT_DIR . '/vc-templates';
	vc_set_shortcodes_templates_dir( $dir );
}

if ( ! function_exists( 'justicia_mikado_configure_visual_composer_frontend_editor' ) ) {
	/**
	 * Configuration for Visual Composer FrontEnd Editor
	 * Hooks on vc_after_init action
	 */
	function justicia_mikado_configure_visual_composer_frontend_editor() {
		/**
		 * Remove frontend editor
		 */
		if ( function_exists( 'vc_disable_frontend' ) ) {
			vc_disable_frontend();
		}
	}
	
	add_action( 'vc_after_init', 'justicia_mikado_configure_visual_composer_frontend_editor' );
}

if ( ! function_exists( 'justicia_mikado_vc_row_map' ) ) {
	/**
	 * Map VC Row shortcode
	 * Hooks on vc_after_init action
	 */
	function justicia_mikado_vc_row_map() {
		
		/******* VC Row shortcode - begin *******/
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'row_content_width',
				'heading'    => esc_html__( 'Mikado Row Content Width', 'justicia' ),
				'value'      => array(
					esc_html__( 'Full Width', 'justicia' ) => 'full-width',
					esc_html__( 'In Grid', 'justicia' )    => 'grid'
				),
				'group'      => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'anchor',
				'heading'     => esc_html__( 'Mikado Anchor ID', 'justicia' ),
				'description' => esc_html__( 'For example "home"', 'justicia' ),
				'group'       => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'colorpicker',
				'param_name' => 'simple_background_color',
				'heading'    => esc_html__( 'Mikado Background Color', 'justicia' ),
				'group'      => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);

		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'simple_arrow',
				'heading'    => esc_html__( 'Mikado Arrow on Bottom', 'justicia' ),
				'group'      => esc_html__( 'Mikado Settings', 'justicia' ),
				'value'       => array(
					esc_html__( 'No', 'justicia' )  => '',
					esc_html__( 'Yes', 'justicia' ) => 'enable_arrow',
				),
				'dependency'  => array( 'element' => 'simple_background_color', 'not_empty' => true ),
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'simple_background_image',
				'heading'    => esc_html__( 'Mikado Background Image', 'justicia' ),
				'group'      => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'background_image_position',
				'heading'     => esc_html__( 'Mikado Background Position', 'justicia' ),
				'description' => esc_html__( 'Set the starting position of a background image, default value is top left', 'justicia' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'disable_background_image',
				'heading'     => esc_html__( 'Mikado Disable Background Image', 'justicia' ),
				'value'       => array(
					esc_html__( 'Never', 'justicia' )        => '',
					esc_html__( 'Below 1280px', 'justicia' ) => '1280',
					esc_html__( 'Below 1024px', 'justicia' ) => '1024',
					esc_html__( 'Below 768px', 'justicia' )  => '768',
					esc_html__( 'Below 680px', 'justicia' )  => '680',
					esc_html__( 'Below 480px', 'justicia' )  => '480'
				),
				'save_always' => true,
				'description' => esc_html__( 'Choose on which stage you hide row background image', 'justicia' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'parallax_background_image',
				'heading'    => esc_html__( 'Mikado Parallax Background Image', 'justicia' ),
				'group'      => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'parallax_bg_speed',
				'heading'     => esc_html__( 'Mikado Parallax Speed', 'justicia' ),
				'description' => esc_html__( 'Set your parallax speed. Default value is 1.', 'justicia' ),
				'dependency'  => array( 'element' => 'parallax_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'textfield',
				'param_name' => 'parallax_bg_height',
				'heading'    => esc_html__( 'Mikado Parallax Section Height (px)', 'justicia' ),
				'dependency' => array( 'element' => 'parallax_background_image', 'not_empty' => true ),
				'group'      => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'content_text_aligment',
				'heading'    => esc_html__( 'Mikado Content Aligment', 'justicia' ),
				'value'      => array(
					esc_html__( 'Default', 'justicia' ) => '',
					esc_html__( 'Left', 'justicia' )    => 'left',
					esc_html__( 'Center', 'justicia' )  => 'center',
					esc_html__( 'Right', 'justicia' )   => 'right'
				),
				'group'      => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);

		do_action( 'justicia_mikado_action_additional_vc_row_params' );
		
		/******* VC Row shortcode - end *******/
		
		/******* VC Row Inner shortcode - begin *******/
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'row_content_width',
				'heading'    => esc_html__( 'Mikado Row Content Width', 'justicia' ),
				'value'      => array(
					esc_html__( 'Full Width', 'justicia' ) => 'full-width',
					esc_html__( 'In Grid', 'justicia' )    => 'grid'
				),
				'group'      => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'colorpicker',
				'param_name' => 'simple_background_color',
				'heading'    => esc_html__( 'Mikado Background Color', 'justicia' ),
				'group'      => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'attach_image',
				'param_name' => 'simple_background_image',
				'heading'    => esc_html__( 'Mikado Background Image', 'justicia' ),
				'group'      => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'        => 'textfield',
				'param_name'  => 'background_image_position',
				'heading'     => esc_html__( 'Mikado Background Position', 'justicia' ),
				'description' => esc_html__( 'Set the starting position of a background image, default value is top left', 'justicia' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'disable_background_image',
				'heading'     => esc_html__( 'Mikado Disable Background Image', 'justicia' ),
				'value'       => array(
					esc_html__( 'Never', 'justicia' )        => '',
					esc_html__( 'Below 1280px', 'justicia' ) => '1280',
					esc_html__( 'Below 1024px', 'justicia' ) => '1024',
					esc_html__( 'Below 768px', 'justicia' )  => '768',
					esc_html__( 'Below 680px', 'justicia' )  => '680',
					esc_html__( 'Below 480px', 'justicia' )  => '480'
				),
				'save_always' => true,
				'description' => esc_html__( 'Choose on which stage you hide row background image', 'justicia' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'content_text_aligment',
				'heading'    => esc_html__( 'Mikado Content Aligment', 'justicia' ),
				'value'      => array(
					esc_html__( 'Default', 'justicia' ) => '',
					esc_html__( 'Left', 'justicia' )    => 'left',
					esc_html__( 'Center', 'justicia' )  => 'center',
					esc_html__( 'Right', 'justicia' )   => 'right'
				),
				'group'      => esc_html__( 'Mikado Settings', 'justicia' )
			)
		);
		
		/******* VC Row Inner shortcode - end *******/
		
		/******* VC Revolution Slider shortcode - begin *******/
		
		if ( justicia_mikado_revolution_slider_installed() ) {
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'enable_paspartu',
					'heading'     => esc_html__( 'Mikado Enable Passepartout', 'justicia' ),
					'value'       => array_flip( justicia_mikado_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'group'       => esc_html__( 'Mikado Settings', 'justicia' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'paspartu_size',
					'heading'     => esc_html__( 'Mikado Passepartout Size', 'justicia' ),
					'value'       => array(
						esc_html__( 'Tiny', 'justicia' )   => 'tiny',
						esc_html__( 'Small', 'justicia' )  => 'small',
						esc_html__( 'Normal', 'justicia' ) => 'normal',
						esc_html__( 'Large', 'justicia' )  => 'large'
					),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Mikado Settings', 'justicia' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'disable_side_paspartu',
					'heading'     => esc_html__( 'Mikado Disable Side Passepartout', 'justicia' ),
					'value'       => array_flip( justicia_mikado_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Mikado Settings', 'justicia' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'disable_top_paspartu',
					'heading'     => esc_html__( 'Mikado Disable Top Passepartout', 'justicia' ),
					'value'       => array_flip( justicia_mikado_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Mikado Settings', 'justicia' )
				)
			);

			vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_1',
                    'heading'    => esc_html__( 'Background Text', 'justicia' ),
                    'group'      => esc_html__( 'Mikado Settings', 'justicia' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_size',
                    'heading'    => esc_html__( 'Background Text Size', 'justicia' ),
                    'description' => esc_html__( 'Set the background text size in px or em', 'justicia' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'justicia' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_size_1440',
                    'heading'    => esc_html__( 'Background Text Size 1280px-1440px', 'justicia' ),
                    'description' => esc_html__( 'Set the background text size in px or em', 'justicia' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'justicia' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_size_1280',
                    'heading'    => esc_html__( 'Background Text Size 1024px-1280px', 'justicia' ),
                    'description' => esc_html__( 'Set the background text size in px or em', 'justicia' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'justicia' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'colorpicker',
                    'param_name' => 'row_background_text_color',
                    'heading'    => esc_html__( 'Background Text Color', 'justicia' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'justicia' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'dropdown',
                    'param_name' => 'row_background_text_align',
                    'heading'    => esc_html__( 'Background Text Align', 'justicia' ),
                    'value'      => array(
                        esc_html__( 'Default', 'justicia' ) => '',
                        esc_html__( 'Left', 'justicia' )    => 'left',
                        esc_html__( 'Center', 'justicia' )  => 'center',
                        esc_html__( 'Right', 'justicia' )   => 'right'
                    ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'justicia' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'dropdown',
                    'param_name' => 'row_background_text_vertical_align',
                    'heading'    => esc_html__( 'Background Vertical Align', 'justicia' ),
                    'value'      => array(
                        esc_html__( 'Middle', 'justicia' )   => 'middle',
                        esc_html__( 'Top', 'justicia' )      => 'top',
                        esc_html__( 'Bottom', 'justicia' )   => 'bottom'
                    ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'justicia' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_padding_top',
                    'heading'    => esc_html__( 'Background Text Top Padding', 'justicia' ),
                    'description' => esc_html__( 'Set the value of top padding in px or %', 'justicia' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'justicia' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_padding_left',
                    'heading'    => esc_html__( 'Background Text Left Padding', 'justicia' ),
                    'description' => esc_html__( 'Set the value of left padding in px or %', 'justicia' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'justicia' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_padding_right',
                    'heading'    => esc_html__( 'Background Text Right Padding', 'justicia' ),
                    'description' => esc_html__( 'Set the value of right padding in px or %', 'justicia' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'justicia' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_margin_top',
                    'heading'    => esc_html__( 'Background Text Top Margin', 'justicia' ),
                    'description' => esc_html__( 'Set the value of top margin in px or %', 'justicia' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'justicia' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'dropdown',
                    'param_name' => 'row_background_text_animation',
                    'heading'    => esc_html__( 'Animate Background Text', 'justicia' ),
                    'value'      => array_flip( justicia_mikado_get_yes_no_select_array(false, true) ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'description'    => esc_html__( 'Animate background text when row appears in viewport', 'justicia' ),
                    'group'      => esc_html__( 'Mikado Settings', 'justicia' )
                )
            );

		}
		
		/******* VC Revolution Slider shortcode - end *******/
	}
	
	add_action( 'vc_after_init', 'justicia_mikado_vc_row_map' );
}