<?php

if ( ! function_exists( 'justicia_mikado_get_title_types_meta_boxes' ) ) {
	function justicia_mikado_get_title_types_meta_boxes() {
		$title_type_options = apply_filters( 'justicia_mikado_filter_title_type_meta_boxes', $title_type_options = array( '' => esc_html__( 'Default', 'justicia' ) ) );
		
		return $title_type_options;
	}
}

foreach ( glob( MIKADO_FRAMEWORK_MODULES_ROOT_DIR . '/title/types/*/admin/meta-boxes/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'justicia_mikado_map_title_meta' ) ) {
	function justicia_mikado_map_title_meta() {
		$title_type_meta_boxes = justicia_mikado_get_title_types_meta_boxes();
		
		$title_meta_box = justicia_mikado_create_meta_box(
			array(
				'scope' => apply_filters( 'justicia_mikado_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'title_meta' ),
				'title' => esc_html__( 'Title', 'justicia' ),
				'name'  => 'title_meta'
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_show_title_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'justicia' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'justicia' ),
				'parent'        => $title_meta_box,
				'options'       => justicia_mikado_get_yes_no_select_array()
			)
		);
		
			$show_title_area_meta_container = justicia_mikado_add_admin_container(
				array(
					'parent'          => $title_meta_box,
					'name'            => 'mkdf_show_title_area_meta_container',
					'dependency' => array(
						'hide' => array(
							'mkdf_show_title_area_meta' => 'no'
						)
					)
				)
			);
		
				justicia_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_title_area_type_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area Type', 'justicia' ),
						'description'   => esc_html__( 'Choose title type', 'justicia' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => $title_type_meta_boxes
					)
				);
		
				justicia_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_title_area_in_grid_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area In Grid', 'justicia' ),
						'description'   => esc_html__( 'Set title area content to be in grid', 'justicia' ),
						'options'       => justicia_mikado_get_yes_no_select_array(),
						'parent'        => $show_title_area_meta_container
					)
				);
		
				justicia_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_title_area_height_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Height', 'justicia' ),
						'description' => esc_html__( 'Set a height for Title Area', 'justicia' ),
						'parent'      => $show_title_area_meta_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px'
						)
					)
				);
				
				justicia_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_title_area_background_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Background Color', 'justicia' ),
						'description' => esc_html__( 'Choose a background color for title area', 'justicia' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				justicia_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_title_area_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'justicia' ),
						'description' => esc_html__( 'Choose an Image for title area', 'justicia' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				justicia_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_title_area_background_image_behavior_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Behavior', 'justicia' ),
						'description'   => esc_html__( 'Choose title area background image behavior', 'justicia' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''                    => esc_html__( 'Default', 'justicia' ),
							'hide'                => esc_html__( 'Hide Image', 'justicia' ),
							'responsive'          => esc_html__( 'Enable Responsive Image', 'justicia' ),
							'responsive-disabled' => esc_html__( 'Disable Responsive Image', 'justicia' ),
							'parallax'            => esc_html__( 'Enable Parallax Image', 'justicia' ),
							'parallax-zoom-out'   => esc_html__( 'Enable Parallax With Zoom Out Image', 'justicia' ),
							'parallax-disabled'   => esc_html__( 'Disable Parallax Image', 'justicia' )
						)
					)
				);
				
				justicia_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_title_area_vertical_alignment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Vertical Alignment', 'justicia' ),
						'description'   => esc_html__( 'Specify title area content vertical alignment', 'justicia' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''              => esc_html__( 'Default', 'justicia' ),
							'header-bottom' => esc_html__( 'From Bottom of Header', 'justicia' ),
							'window-top'    => esc_html__( 'From Window Top', 'justicia' )
						)
					)
				);
				
				justicia_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_title_area_title_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Tag', 'justicia' ),
						'options'       => justicia_mikado_get_title_tag( true ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				justicia_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_title_text_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Title Color', 'justicia' ),
						'description' => esc_html__( 'Choose a color for title text', 'justicia' ),
						'parent'      => $show_title_area_meta_container
					)
				);
				
				justicia_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_title_area_subtitle_meta',
						'type'          => 'text',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Text', 'justicia' ),
						'description'   => esc_html__( 'Enter your subtitle text', 'justicia' ),
						'parent'        => $show_title_area_meta_container,
						'args'          => array(
							'col_width' => 6
						)
					)
				);
		
				justicia_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_title_area_subtitle_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Tag', 'justicia' ),
						'options'       => justicia_mikado_get_title_tag( true, array( 'p' => 'p' ) ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				justicia_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_subtitle_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Subtitle Color', 'justicia' ),
						'description' => esc_html__( 'Choose a color for subtitle text', 'justicia' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
		/***************** Additional Title Area Layout - start *****************/
		
		do_action( 'justicia_mikado_action_additional_title_area_meta_boxes', $show_title_area_meta_container );
		
		/***************** Additional Title Area Layout - end *****************/
		
	}
	
	add_action( 'justicia_mikado_action_meta_boxes_map', 'justicia_mikado_map_title_meta', 60 );
}