<?php

if ( ! function_exists( 'justicia_mikado_sidebar_options_map' ) ) {
	function justicia_mikado_sidebar_options_map() {
		
		justicia_mikado_add_admin_page(
			array(
				'slug'  => '_sidebar_page',
				'title' => esc_html__( 'Sidebar Area', 'justicia' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$sidebar_panel = justicia_mikado_add_admin_panel(
			array(
				'title' => esc_html__( 'Sidebar Area', 'justicia' ),
				'name'  => 'sidebar',
				'page'  => '_sidebar_page'
			)
		);
		
		justicia_mikado_add_admin_field( array(
			'name'          => 'sidebar_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Sidebar Layout', 'justicia' ),
			'description'   => esc_html__( 'Choose a sidebar layout for pages', 'justicia' ),
			'parent'        => $sidebar_panel,
			'default_value' => 'no-sidebar',
            'options'       => justicia_mikado_get_custom_sidebars_options()
		) );
		
		$justicia_custom_sidebars = justicia_mikado_get_custom_sidebars();
		if ( count( $justicia_custom_sidebars ) > 0 ) {
			justicia_mikado_add_admin_field( array(
				'name'        => 'custom_sidebar_area',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'justicia' ),
				'description' => esc_html__( 'Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'justicia' ),
				'parent'      => $sidebar_panel,
				'options'     => $justicia_custom_sidebars,
				'args'        => array(
					'select2' => true
				)
			) );
		}
	}
	
	add_action( 'justicia_mikado_action_options_map', 'justicia_mikado_sidebar_options_map', justicia_mikado_set_options_map_position( 'sidebar' ) );
}