<?php

if ( ! function_exists( 'justicia_mikado_map_sidebar_meta' ) ) {
	function justicia_mikado_map_sidebar_meta() {
		$mkdf_sidebar_meta_box = justicia_mikado_create_meta_box(
			array(
				'scope' => apply_filters( 'justicia_mikado_filter_set_scope_for_meta_boxes', array( 'page' ), 'sidebar_meta' ),
				'title' => esc_html__( 'Sidebar', 'justicia' ),
				'name'  => 'sidebar_meta'
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_sidebar_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Sidebar Layout', 'justicia' ),
				'description' => esc_html__( 'Choose the sidebar layout', 'justicia' ),
				'parent'      => $mkdf_sidebar_meta_box,
                'options'       => justicia_mikado_get_custom_sidebars_options( true )
			)
		);
		
		$mkdf_custom_sidebars = justicia_mikado_get_custom_sidebars();
		if ( count( $mkdf_custom_sidebars ) > 0 ) {
			justicia_mikado_create_meta_box_field(
				array(
					'name'        => 'mkdf_custom_sidebar_area_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Widget Area in Sidebar', 'justicia' ),
					'description' => esc_html__( 'Choose Custom Widget area to display in Sidebar"', 'justicia' ),
					'parent'      => $mkdf_sidebar_meta_box,
					'options'     => $mkdf_custom_sidebars,
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
	}
	
	add_action( 'justicia_mikado_action_meta_boxes_map', 'justicia_mikado_map_sidebar_meta', 31 );
}