<?php

if ( class_exists( 'JusticiaCoreClassWidget' ) ) {
    class JusticiaMikadoClassSideAreaOpener extends JusticiaCoreClassWidget {
        public function __construct() {
            parent::__construct(
                'mkdf_side_area_opener',
                esc_html__( 'Justicia Side Area Opener', 'justicia' ),
                array( 'description' => esc_html__( 'Display a "hamburger" icon that opens the side area', 'justicia' ) )
            );

            $this->setParams();
        }

        protected function setParams() {
            $this->params = array(
                array(
                    'type'        => 'colorpicker',
                    'name'        => 'icon_color',
                    'title'       => esc_html__( 'Side Area Opener Color', 'justicia' ),
                    'description' => esc_html__( 'Define color for side area opener', 'justicia' )
                ),
                array(
                    'type'        => 'colorpicker',
                    'name'        => 'icon_hover_color',
                    'title'       => esc_html__( 'Side Area Opener Hover Color', 'justicia' ),
                    'description' => esc_html__( 'Define hover color for side area opener', 'justicia' )
                ),
                array(
                    'type'        => 'dropdown',
                    'name'  	  => 'boxed_style',
                    'title'       => esc_html__( 'Box Style', 'justicia' ),
                    'description' => esc_html__( 'Add Box around the icon', 'justicia' ),
                    'options'     => justicia_mikado_get_yes_no_select_array( false, true )
                ),
                array(
                    'type'        => 'textfield',
                    'name'        => 'widget_margin',
                    'title'       => esc_html__( 'Side Area Opener Margin', 'justicia' ),
                    'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'justicia' )
                ),
                array(
                    'type'  => 'textfield',
                    'name'  => 'widget_title',
                    'title' => esc_html__( 'Side Area Opener Title', 'justicia' )
                )
            );
        }

        public function widget( $args, $instance ) {


            $classes = array(
                'mkdf-side-menu-button-opener',
                'mkdf-icon-has-hover'
            );

            if (  $instance['boxed_style'] === 'yes' ) {
                $classes[] = 'boxed-enabled';
            }

            $classes[] = justicia_mikado_get_icon_sources_class( 'side_area', 'mkdf-side-menu-button-opener' );

            $styles = array();
            if ( ! empty( $instance['icon_color'] ) ) {
                $styles[] = 'color: ' . $instance['icon_color'] . ';';
                $styles[] = 'background-color: ' . $instance['icon_color'];
            }
            if ( ! empty( $instance['widget_margin'] ) ) {
                $styles[] = 'margin: ' . $instance['widget_margin'];
            }
            ?>

            <a <?php justicia_mikado_class_attribute( $classes ); ?> <?php echo justicia_mikado_get_inline_attr( $instance['icon_hover_color'], 'data-hover-color' ); ?> href="javascript:void(0)" <?php justicia_mikado_inline_style( $styles ); ?>>
			<span class="mkdf-lines-holder">
				<span class="mkdf-lines-holder-inner">
					<span class="mkdf-lines line-1" <?php justicia_mikado_inline_style($styles) ?>></span>
					<span class="mkdf-lines line-2" <?php justicia_mikado_inline_style($styles) ?>></span>
					<span class="mkdf-lines line-3" <?php justicia_mikado_inline_style($styles) ?>></span>
					<span class="mkdf-lines line-4" <?php justicia_mikado_inline_style($styles) ?>></span>
				</span>
           	</span>
                <?php if ( ! empty( $instance['widget_title'] ) ) { ?>
                    <span class="mkdf-side-menu-title"><?php echo esc_html( $instance['widget_title'] ); ?></span>
                <?php } ?>
            </a>
        <?php }
    }
}

