<?php

if ( ! function_exists( 'justicia_mikado_fullscreen_search_general_styles' ) ) {
	function justicia_mikado_fullscreen_search_general_styles() {
		
		$background_image         = justicia_mikado_options()->getOptionValue( 'fullscreen_search_background_image' );
		
		if ( ! empty( $background_image ) ) {
			echo justicia_mikado_dynamic_css( '.mkdf-fullscreen-search-table', array(
				'background-image'    => 'url(' . esc_url( $background_image ) . ')',
				'background-position' => 'center 0',
				'background-repeat'   => 'no-repeat'
			) );
		}
		
	}
	
	add_action( 'justicia_mikado_action_style_dynamic', 'justicia_mikado_fullscreen_search_general_styles' );
}

if ( ! function_exists( 'justicia_mikado_search_opener_icon_size' ) ) {
	function justicia_mikado_search_opener_icon_size() {
		$icon_size = justicia_mikado_options()->getOptionValue( 'header_search_icon_size' );
		
		if ( ! empty( $icon_size ) ) {
			echo justicia_mikado_dynamic_css( '.mkdf-search-opener', array(
				'font-size' => justicia_mikado_filter_px( $icon_size ) . 'px'
			) );
		}
	}
	
	add_action( 'justicia_mikado_action_style_dynamic', 'justicia_mikado_search_opener_icon_size' );
}

if ( ! function_exists( 'justicia_mikado_search_opener_icon_colors' ) ) {
	function justicia_mikado_search_opener_icon_colors() {
		$icon_color       = justicia_mikado_options()->getOptionValue( 'header_search_icon_color' );
		$icon_hover_color = justicia_mikado_options()->getOptionValue( 'header_search_icon_hover_color' );
		
		if ( ! empty( $icon_color ) ) {
			echo justicia_mikado_dynamic_css( '.mkdf-search-opener', array(
				'color' => $icon_color
			) );
		}
		
		if ( ! empty( $icon_hover_color ) ) {
			echo justicia_mikado_dynamic_css( '.mkdf-search-opener:hover', array(
				'color' => $icon_hover_color
			) );
		}
	}
	
	add_action( 'justicia_mikado_action_style_dynamic', 'justicia_mikado_search_opener_icon_colors' );
}

if ( ! function_exists( 'justicia_mikado_search_opener_text_styles' ) ) {
	function justicia_mikado_search_opener_text_styles() {
		$item_styles = justicia_mikado_get_typography_styles( 'search_icon_text' );
		
		$item_selector = array(
			'.mkdf-search-icon-text'
		);
		
		echo justicia_mikado_dynamic_css( $item_selector, $item_styles );
		
		$text_hover_color = justicia_mikado_options()->getOptionValue( 'search_icon_text_color_hover' );
		
		if ( ! empty( $text_hover_color ) ) {
			echo justicia_mikado_dynamic_css( '.mkdf-search-opener:hover .mkdf-search-icon-text', array(
				'color' => $text_hover_color
			) );
		}
	}
	
	add_action( 'justicia_mikado_action_style_dynamic', 'justicia_mikado_search_opener_text_styles' );
}