<?php

if ( ! function_exists( 'justicia_mikado_get_hide_dep_for_header_standard_meta_boxes' ) ) {
	function justicia_mikado_get_hide_dep_for_header_standard_meta_boxes() {
		$hide_dep_options = apply_filters( 'justicia_mikado_filter_header_standard_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'justicia_mikado_header_standard_meta_map' ) ) {
	function justicia_mikado_header_standard_meta_map( $parent ) {
		$hide_dep_options = justicia_mikado_get_hide_dep_for_header_standard_meta_boxes();
		
		justicia_mikado_create_meta_box_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'mkdf_set_menu_area_position_meta',
				'default_value'   => '',
				'label'           => esc_html__( 'Choose Menu Area Position', 'justicia' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'justicia' ),
				'options'         => array(
					''       => esc_html__( 'Default', 'justicia' ),
					'left'   => esc_html__( 'Left', 'justicia' ),
					'right'  => esc_html__( 'Right', 'justicia' ),
					'center' => esc_html__( 'Center', 'justicia' )
				),
				'dependency' => array(
					'hide' => array(
						'mkdf_header_type_meta'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'justicia_mikado_action_additional_header_area_meta_boxes_map', 'justicia_mikado_header_standard_meta_map' );
}