<?php

if ( ! function_exists( 'justicia_mikado_footer_options_map' ) ) {
	function justicia_mikado_footer_options_map() {

		justicia_mikado_add_admin_page(
			array(
				'slug'  => '_footer_page',
				'title' => esc_html__( 'Footer', 'justicia' ),
				'icon'  => 'fa fa-sort-amount-asc'
			)
		);

		$footer_panel = justicia_mikado_add_admin_panel(
			array(
				'title' => esc_html__( 'Footer', 'justicia' ),
				'name'  => 'footer',
				'page'  => '_footer_page'
			)
		);

		justicia_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'footer_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Footer in Grid', 'justicia' ),
				'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'justicia' ),
				'parent'        => $footer_panel
			)
		);

        justicia_mikado_add_admin_field(
            array(
                'type'          => 'yesno',
                'name'          => 'uncovering_footer',
                'default_value' => 'no',
                'label'         => esc_html__( 'Uncovering Footer', 'justicia' ),
                'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'justicia' ),
                'parent'        => $footer_panel
            )
        );

		justicia_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_top',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Top', 'justicia' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'justicia' ),
				'parent'        => $footer_panel
			)
		);
		
		$show_footer_top_container = justicia_mikado_add_admin_container(
			array(
				'name'       => 'show_footer_top_container',
				'parent'     => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_top' => 'yes'
					)
				)
			)
		);

		justicia_mikado_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns',
				'parent'        => $show_footer_top_container,
				'default_value' => '3 3 3 3',
				'label'         => esc_html__( 'Footer Top Columns', 'justicia' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Top area', 'justicia' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3',
                    '3 3 6' => '3 (25% + 25% + 50%)',
					'3 3 3 3' => '4'
				)
			)
		);

		justicia_mikado_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns_alignment',
				'default_value' => 'left',
				'label'         => esc_html__( 'Footer Top Columns Alignment', 'justicia' ),
				'description'   => esc_html__( 'Text Alignment in Footer Columns', 'justicia' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'justicia' ),
					'left'   => esc_html__( 'Left', 'justicia' ),
					'center' => esc_html__( 'Center', 'justicia' ),
					'right'  => esc_html__( 'Right', 'justicia' )
				),
				'parent'        => $show_footer_top_container
			)
		);
		
		$footer_top_styles_group = justicia_mikado_add_admin_group(
			array(
				'name'        => 'footer_top_styles_group',
				'title'       => esc_html__( 'Footer Top Styles', 'justicia' ),
				'description' => esc_html__( 'Define style for footer top area', 'justicia' ),
				'parent'      => $show_footer_top_container
			)
		);
		
		$footer_top_styles_row_1 = justicia_mikado_add_admin_row(
			array(
				'name'   => 'footer_top_styles_row_1',
				'parent' => $footer_top_styles_group
			)
		);
		
			justicia_mikado_add_admin_field(
				array(
					'name'   => 'footer_top_background_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Background Color', 'justicia' ),
					'parent' => $footer_top_styles_row_1
				)
			);
			
			justicia_mikado_add_admin_field(
				array(
					'name'   => 'footer_top_border_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Border Color', 'justicia' ),
					'parent' => $footer_top_styles_row_1
				)
			);
			
			justicia_mikado_add_admin_field(
				array(
					'name'   => 'footer_top_border_width',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'Border Width', 'justicia' ),
					'parent' => $footer_top_styles_row_1,
					'args'   => array(
						'suffix' => 'px'
					)
				)
			);

		justicia_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_bottom',
				'default_value' => 'no',
				'label'         => esc_html__( 'Show Footer Bottom', 'justicia' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'justicia' ),
				'parent'        => $footer_panel
			)
		);

		$show_footer_bottom_container = justicia_mikado_add_admin_container(
			array(
				'name'            => 'show_footer_bottom_container',
				'parent'          => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_bottom'  => 'yes'
					)
				)
			)
		);

		justicia_mikado_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_bottom_columns',
				'default_value' => '6 6',
				'label'         => esc_html__( 'Footer Bottom Columns', 'justicia' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Bottom area', 'justicia' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3'
				),
				'parent'        => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_group = justicia_mikado_add_admin_group(
			array(
				'name'        => 'footer_bottom_styles_group',
				'title'       => esc_html__( 'Footer Bottom Styles', 'justicia' ),
				'description' => esc_html__( 'Define style for footer bottom area', 'justicia' ),
				'parent'      => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_row_1 = justicia_mikado_add_admin_row(
			array(
				'name'   => 'footer_bottom_styles_row_1',
				'parent' => $footer_bottom_styles_group
			)
		);
		
			justicia_mikado_add_admin_field(
				array(
					'name'   => 'footer_bottom_background_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Background Color', 'justicia' ),
					'parent' => $footer_bottom_styles_row_1
				)
			);
			
			justicia_mikado_add_admin_field(
				array(
					'name'   => 'footer_bottom_border_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Border Color', 'justicia' ),
					'parent' => $footer_bottom_styles_row_1
				)
			);
			
			justicia_mikado_add_admin_field(
				array(
					'name'   => 'footer_bottom_border_width',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'Border Width', 'justicia' ),
					'parent' => $footer_bottom_styles_row_1,
					'args'   => array(
						'suffix' => 'px'
					)
				)
			);
	}

	add_action( 'justicia_mikado_action_options_map', 'justicia_mikado_footer_options_map', justicia_mikado_set_options_map_position( 'footer' ) );
}