<?php

if ( ! function_exists( 'justicia_mikado_map_footer_meta' ) ) {
	function justicia_mikado_map_footer_meta() {
		
		$footer_meta_box = justicia_mikado_create_meta_box(
			array(
				'scope' => apply_filters( 'justicia_mikado_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'footer_meta' ),
				'title' => esc_html__( 'Footer', 'justicia' ),
				'name'  => 'footer_meta'
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_disable_footer_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Disable Footer for this Page', 'justicia' ),
				'description'   => esc_html__( 'Enabling this option will hide footer on this page', 'justicia' ),
				'options'       => justicia_mikado_get_yes_no_select_array(),
				'parent'        => $footer_meta_box
			)
		);
		
		$show_footer_meta_container = justicia_mikado_add_admin_container(
			array(
				'name'       => 'mkdf_show_footer_meta_container',
				'parent'     => $footer_meta_box,
				'dependency' => array(
					'hide' => array(
						'mkdf_disable_footer_meta' => 'yes'
					)
				)
			)
		);
		
			justicia_mikado_create_meta_box_field(
				array(
					'name'          => 'mkdf_footer_in_grid_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Footer in Grid', 'justicia' ),
					'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'justicia' ),
					'options'       => justicia_mikado_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
			
			justicia_mikado_create_meta_box_field(
				array(
					'name'          => 'mkdf_uncovering_footer_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Uncovering Footer', 'justicia' ),
					'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'justicia' ),
					'options'       => justicia_mikado_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
		
			justicia_mikado_create_meta_box_field(
				array(
					'name'          => 'mkdf_show_footer_top_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Show Footer Top', 'justicia' ),
					'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'justicia' ),
					'options'       => justicia_mikado_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
		
			$footer_top_styles_group = justicia_mikado_add_admin_group(
				array(
					'name'        => 'footer_top_styles_group',
					'title'       => esc_html__( 'Footer Top Styles', 'justicia' ),
					'description' => esc_html__( 'Define style for footer top area', 'justicia' ),
					'parent'      => $show_footer_meta_container,
					'dependency'  => array(
						'show' => array(
							'mkdf_show_footer_top_meta' => array( '', 'yes' )
						)
					)
				)
			);
			
			$footer_top_styles_row_1 = justicia_mikado_add_admin_row(
				array(
					'name'   => 'footer_top_styles_row_1',
					'parent' => $footer_top_styles_group
				)
			);
		
				justicia_mikado_create_meta_box_field(
					array(
						'name'   => 'mkdf_footer_top_background_color_meta',
						'type'   => 'colorsimple',
						'label'  => esc_html__( 'Background Color', 'justicia' ),
						'parent' => $footer_top_styles_row_1
					)
				);
		
				justicia_mikado_create_meta_box_field(
					array(
						'name'   => 'mkdf_footer_top_border_color_meta',
						'type'   => 'colorsimple',
						'label'  => esc_html__( 'Border Color', 'justicia' ),
						'parent' => $footer_top_styles_row_1
					)
				);
		
				justicia_mikado_create_meta_box_field(
					array(
						'name'   => 'mkdf_footer_top_border_width_meta',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Border Width', 'justicia' ),
						'parent' => $footer_top_styles_row_1,
						'args'   => array(
							'suffix' => 'px'
						)
					)
				);
			
			justicia_mikado_create_meta_box_field(
				array(
					'name'          => 'mkdf_show_footer_bottom_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Show Footer Bottom', 'justicia' ),
					'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'justicia' ),
					'options'       => justicia_mikado_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
		
			$footer_bottom_styles_group = justicia_mikado_add_admin_group(
				array(
					'name'        => 'footer_bottom_styles_group',
					'title'       => esc_html__( 'Footer Bottom Styles', 'justicia' ),
					'description' => esc_html__( 'Define style for footer bottom area', 'justicia' ),
					'parent'      => $show_footer_meta_container,
					'dependency'  => array(
						'show' => array(
							'mkdf_show_footer_bottom_meta' => array( '', 'yes' )
						)
					)
				)
			);
			
			$footer_bottom_styles_row_1 = justicia_mikado_add_admin_row(
				array(
					'name'   => 'footer_bottom_styles_row_1',
					'parent' => $footer_bottom_styles_group
				)
			);
			
				justicia_mikado_create_meta_box_field(
					array(
						'name'   => 'mkdf_footer_bottom_background_color_meta',
						'type'   => 'colorsimple',
						'label'  => esc_html__( 'Background Color', 'justicia' ),
						'parent' => $footer_bottom_styles_row_1
					)
				);
				
				justicia_mikado_create_meta_box_field(
					array(
						'name'   => 'mkdf_footer_bottom_border_color_meta',
						'type'   => 'colorsimple',
						'label'  => esc_html__( 'Border Color', 'justicia' ),
						'parent' => $footer_bottom_styles_row_1
					)
				);
				
				justicia_mikado_create_meta_box_field(
					array(
						'name'   => 'mkdf_footer_bottom_border_width_meta',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Border Width', 'justicia' ),
						'parent' => $footer_bottom_styles_row_1,
						'args'   => array(
							'suffix' => 'px'
						)
					)
				);
	}
	
	add_action( 'justicia_mikado_action_meta_boxes_map', 'justicia_mikado_map_footer_meta', 70 );
}