<?php

if ( ! function_exists( 'justicia_mikado_map_post_video_meta' ) ) {
	function justicia_mikado_map_post_video_meta() {
		$video_post_format_meta_box = justicia_mikado_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Video Post Format', 'justicia' ),
				'name'  => 'post_format_video_meta'
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_video_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Video Type', 'justicia' ),
				'description'   => esc_html__( 'Choose video type', 'justicia' ),
				'parent'        => $video_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Video Service', 'justicia' ),
					'self'            => esc_html__( 'Self Hosted', 'justicia' )
				)
			)
		);
		
		$mkdf_video_embedded_container = justicia_mikado_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name'   => 'mkdf_video_embedded_container'
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_video_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video URL', 'justicia' ),
				'description' => esc_html__( 'Enter Video URL', 'justicia' ),
				'parent'      => $mkdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_video_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_video_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video MP4', 'justicia' ),
				'description' => esc_html__( 'Enter video URL for MP4 format', 'justicia' ),
				'parent'      => $mkdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_video_type_meta' => 'self'
					)
				)
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Video Image', 'justicia' ),
				'description' => esc_html__( 'Enter video image', 'justicia' ),
				'parent'      => $mkdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_video_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'justicia_mikado_action_meta_boxes_map', 'justicia_mikado_map_post_video_meta', 22 );
}