<?php

if ( ! function_exists( 'justicia_mikado_map_post_audio_meta' ) ) {
	function justicia_mikado_map_post_audio_meta() {
		$audio_post_format_meta_box = justicia_mikado_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Audio Post Format', 'justicia' ),
				'name'  => 'post_format_audio_meta'
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_audio_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Audio Type', 'justicia' ),
				'description'   => esc_html__( 'Choose audio type', 'justicia' ),
				'parent'        => $audio_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Audio Service', 'justicia' ),
					'self'            => esc_html__( 'Self Hosted', 'justicia' )
				)
			)
		);
		
		$mkdf_audio_embedded_container = justicia_mikado_add_admin_container(
			array(
				'parent' => $audio_post_format_meta_box,
				'name'   => 'mkdf_audio_embedded_container'
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_audio_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio URL', 'justicia' ),
				'description' => esc_html__( 'Enter audio URL', 'justicia' ),
				'parent'      => $mkdf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_audio_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_audio_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio Link', 'justicia' ),
				'description' => esc_html__( 'Enter audio link', 'justicia' ),
				'parent'      => $mkdf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_audio_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'justicia_mikado_action_meta_boxes_map', 'justicia_mikado_map_post_audio_meta', 23 );
}