<?php

foreach ( glob( MIKADO_FRAMEWORK_MODULES_ROOT_DIR . '/blog/admin/meta-boxes/*/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'justicia_mikado_map_blog_meta' ) ) {
	function justicia_mikado_map_blog_meta() {
		$mkdf_blog_categories = array();
		$categories           = get_categories();
		foreach ( $categories as $category ) {
			$mkdf_blog_categories[ $category->slug ] = $category->name;
		}
		
		$blog_meta_box = justicia_mikado_create_meta_box(
			array(
				'scope' => array( 'page' ),
				'title' => esc_html__( 'Blog', 'justicia' ),
				'name'  => 'blog_meta'
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_blog_category_meta',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Blog Category', 'justicia' ),
				'description' => esc_html__( 'Choose category of posts to display (leave empty to display all categories)', 'justicia' ),
				'parent'      => $blog_meta_box,
				'options'     => $mkdf_blog_categories
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_show_posts_per_page_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Number of Posts', 'justicia' ),
				'description' => esc_html__( 'Enter the number of posts to display', 'justicia' ),
				'parent'      => $blog_meta_box,
				'options'     => $mkdf_blog_categories,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_blog_masonry_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Layout', 'justicia' ),
				'description' => esc_html__( 'Set masonry layout. Default is in grid.', 'justicia' ),
				'parent'      => $blog_meta_box,
				'options'     => array(
					''           => esc_html__( 'Default', 'justicia' ),
					'in-grid'    => esc_html__( 'In Grid', 'justicia' ),
					'full-width' => esc_html__( 'Full Width', 'justicia' )
				)
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_blog_masonry_number_of_columns_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Number of Columns', 'justicia' ),
				'description' => esc_html__( 'Set number of columns for your masonry blog lists', 'justicia' ),
				'parent'      => $blog_meta_box,
				'options'     => justicia_mikado_get_number_of_columns_array( true, array( 'one', 'six' ) )
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_blog_masonry_space_between_items_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Space Between Items', 'justicia' ),
				'description' => esc_html__( 'Set space size between posts for your masonry blog lists', 'justicia' ),
				'options'     => justicia_mikado_get_space_between_items_array( true ),
				'parent'      => $blog_meta_box
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_blog_list_featured_image_proportion_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Masonry - Featured Image Proportion', 'justicia' ),
				'description'   => esc_html__( 'Choose type of proportions you want to use for featured images on masonry blog lists', 'justicia' ),
				'parent'        => $blog_meta_box,
				'default_value' => '',
				'options'       => array(
					''         => esc_html__( 'Default', 'justicia' ),
					'fixed'    => esc_html__( 'Fixed', 'justicia' ),
					'original' => esc_html__( 'Original', 'justicia' )
				)
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_blog_pagination_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Pagination Type', 'justicia' ),
				'description'   => esc_html__( 'Choose a pagination layout for Blog Lists', 'justicia' ),
				'parent'        => $blog_meta_box,
				'default_value' => '',
				'options'       => array(
					''                => esc_html__( 'Default', 'justicia' ),
					'standard'        => esc_html__( 'Standard', 'justicia' ),
					'load-more'       => esc_html__( 'Load More', 'justicia' ),
					'infinite-scroll' => esc_html__( 'Infinite Scroll', 'justicia' ),
					'no-pagination'   => esc_html__( 'No Pagination', 'justicia' )
				)
			)
		);
		
		justicia_mikado_create_meta_box_field(
			array(
				'type'          => 'text',
				'name'          => 'mkdf_number_of_chars_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Number of Words in Excerpt', 'justicia' ),
				'description'   => esc_html__( 'Enter a number of words in excerpt (article summary). Default value is 40', 'justicia' ),
				'parent'        => $blog_meta_box,
				'args'          => array(
					'col_width' => 3
				)
			)
		);
	}
	
	add_action( 'justicia_mikado_action_meta_boxes_map', 'justicia_mikado_map_blog_meta', 30 );
}