<?php
/**
 * The style "Modern" of the Blogger
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_blogger');

if ($args['slider']) {
	?><div class="slider-slide swiper-slide"><?php
} else if ($args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
}

$post_format = get_post_format();
$post_format = empty($post_format) ? 'standard' : str_replace('post-format-', '', $post_format);
$post_link = empty($args['no_links']) ? get_permalink() : '';
$post_title = get_the_title();

$giardino_image_hover = ! empty( $giardino_template_args['hover'] ) && ! giardino_is_inherit( $giardino_template_args['hover'] )
    ? $giardino_template_args['hover']
    : giardino_get_theme_option( 'image_hover' );

?><div <?php post_class( 'sc_blogger_item post_format_'.esc_attr($post_format) . (empty($post_link) ? ' no_links' : '') ); ?>><?php

$counters = giardino_show_post_meta(
    array(
        'components' => 'counters',
        'counters'   => 'likes',
        'seo'        => false,
        'echo' => false
    )
);

	// Featured image
	trx_addons_get_template_part('templates/tpl.featured.php',
									'trx_addons_args_featured',
									apply_filters('trx_addons_filter_args_featured', array(
														'class' => 'sc_blogger_item_featured',
														'hover' => 'zoomin',
														'no_links' => empty($post_link),
														'thumb_size' => apply_filters('trx_addons_filter_thumb_size', trx_addons_get_thumb_size('extra')),
                                                        'post_info'     => 'dots' == $giardino_image_hover ? '<div class="post_info">' . '<span>' . esc_html( get_the_title() ) . '</span>' . $counters  . '</div>' : '',
														))
								);
	
	// Post content
	?><div class="sc_blogger_item_content entry-content"><?php
		// Post excerpt
		if (!isset($args['hide_excerpt']) || $args['hide_excerpt']==0) {
			?><div class="sc_blogger_item_excerpt">
				<div class="sc_blogger_item_excerpt_text">
					<?php
					$show_more = !in_array($post_format, array('link', 'aside', 'status', 'quote'));
					if (has_excerpt()) {
						the_excerpt();
					} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
						the_content( '' );
					} else if (!$show_more) {
						the_content();
					} else {
						the_excerpt();
					}
					?>
				</div>
				<?php
				// Post meta
				if (in_array($post_format, array('link', 'aside', 'status', 'quote'))) {
					trx_addons_sc_show_post_meta('sc_blogger', apply_filters('trx_addons_filter_show_post_meta', array(
						'components' => 'date'
						), 'sc_blogger_modern', $args['columns'])
					);
				}
				// More button
				if ( $show_more && !empty($post_link) && !empty($args['more_text']) ) {
					?><div class="sc_blogger_item_button sc_item_button"><a href="<?php echo esc_url($post_link); ?>" class="<?php echo esc_attr(apply_filters('trx_addons_filter_sc_item_link_classes', 'sc_button', 'sc_blogger', $args)); ?>"><?php
						echo esc_html($args['more_text']);
					?></a></div><?php
				}
			?></div><!-- .sc_blogger_item_excerpt --><?php
		}

	?></div><!-- .entry-content --><?php

?></div><!-- .sc_blogger_item --><?php

if ($args['slider'] || $args['columns'] > 1) {
	?></div><?php
}
?>