<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

$giardino_template_args = get_query_var( 'giardino_template_args' );
if ( is_array( $giardino_template_args ) ) {
    $giardino_columns    = empty( $giardino_template_args['columns'] ) ? 2 : max( 1, $giardino_template_args['columns'] );
    $giardino_blog_style = array( $giardino_template_args['type'], $giardino_columns );
} else {
    $giardino_blog_style = explode( '_', giardino_get_theme_option( 'blog_style' ) );
    $giardino_columns    = empty( $giardino_blog_style[1] ) ? 2 : max( 2, $giardino_blog_style[1] );
}
$giardino_expanded   = ! giardino_sidebar_present() && giardino_is_on( giardino_get_theme_option( 'expand_content' ) );
$giardino_animation  = giardino_get_theme_option( 'blog_animation' );
$giardino_components = giardino_array_get_keys_by_value( giardino_get_theme_option( 'meta_parts' ) );
$giardino_counters   = giardino_array_get_keys_by_value( giardino_get_theme_option( 'counters' ) );

$giardino_post_format = get_post_format();
$giardino_post_format = empty( $giardino_post_format ) ? 'standard' : str_replace( 'post-format-', '', $giardino_post_format );
$giardino_link        = get_permalink();

$args = get_query_var('trx_addons_args_sc_blogger');

?><div class="
<?php
if ( ! empty( $giardino_template_args['slider'] ) ) {
    echo ' slider-slide swiper-slide';
} else {
    echo ( 'classic' .' '. 'column') . '-1_' . esc_attr( $args['columns'] );
}
?>
"><article id="post-<?php the_ID(); ?>"
        <?php
        post_class(
            'post_item post_format_' . esc_attr( $giardino_post_format )
            . ' post_layout_classic post_layout_classic_' . esc_attr( $giardino_columns )
            . ' post_layout_' . esc_attr( $giardino_blog_style[0] )
            . ' post_layout_' . esc_attr( $giardino_blog_style[0] ) . '_' . esc_attr( $giardino_columns )
        );
        echo ( ! giardino_is_off( $giardino_animation ) && empty( $giardino_template_args['slider'] ) ? ' data-animation="' . esc_attr( giardino_get_animation_classes( $giardino_animation ) ) . '"' : '' );
        ?>
    >
        <?php
        // Sticky label
        if ( is_sticky() && ! is_paged() ) {
            ?>
            <span class="post_label label_sticky"></span>
            <?php
        }

        // Featured image
        $giardino_hover = ! empty( $giardino_template_args['hover'] ) && ! giardino_is_inherit( $giardino_template_args['hover'] )
            ? $giardino_template_args['hover']
            : giardino_get_theme_option( 'image_hover' );
        giardino_show_post_featured(
            array(
                'thumb_size' => giardino_get_thumb_size(
                    'classic' == $giardino_blog_style[0]
                        ? ( strpos( giardino_get_theme_option( 'body_style' ), 'full' ) !== false
                        ? ( $args >= 2 ? 'big' : 'huge' )
                        : ( $args > 2
                            ? ( $giardino_expanded ? 'masonry-big' : 'small' )
                            : ( $giardino_expanded ? 'big' : 'med' )
                        )
                    )
                        : ( strpos( giardino_get_theme_option( 'body_style' ), 'full' ) !== false
                        ? ( $args > 2 ? 'masonry-big' : 'full' )
                        : ( $args <= 2 && $giardino_expanded ? 'masonry-big' : 'masonry' )
                    )
                ),
                'hover'      => $giardino_hover,
                'no_links'   => ! empty( $giardino_template_args['no_links'] ),
                'singular'   => false,
            )
        );
        if ( ! in_array( $giardino_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
            ?>
            <div class="post_header entry-header">
                <div class="header_meta">
                <span class="post_date">
                    <a href="<?php echo esc_url( $giardino_link ); ?>"><?php echo wp_kses_data( giardino_get_date() ); ?></a>
                </span>
                    <?php
                    do_action( 'giardino_action_before_post_meta' );

                    // Post meta
                    if ( ! empty( $giardino_components ) && ! in_array( $giardino_hover, array( 'border', 'pull', 'slide', 'fade' ) ) ) {
                        giardino_show_post_meta(
                            apply_filters(
                                'giardino_filter_post_meta_args', array(
                                'components' => 'counters',
                                'counters'   => $giardino_counters,
                                'seo'        => false,
                            ), $giardino_blog_style[0], $giardino_columns
                            )
                        );
                    }
                    do_action( 'giardino_action_after_post_meta' );
                    ?>
                </div>
                <?php
                do_action( 'giardino_action_before_post_title' );

                // Post title
                if ( empty( $giardino_template_args['no_links'] ) ) {
                    the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
                } else {
                    the_title( '<h4 class="post_title entry-title">', '</h4>' );
                }

                ?>
            </div><!-- .entry-header -->
            <?php
        }
        ?>

        <div class="post_content entry-content">
            <?php
            if ( empty( $giardino_template_args['hide_excerpt'] ) ) {
                ?>
                <div class="post_content_inner">
                    <?php
                    if ( has_excerpt() ) {
                        the_excerpt();
                    } elseif ( strpos( get_the_content( '!--more' ), '!--more' ) !== false ) {
                        the_content( '' );
                    } elseif ( in_array( $giardino_post_format, array( 'link', 'aside', 'status' ) ) ) {
                        the_content();
                    } elseif ( 'quote' == $giardino_post_format ) {
                        $quote = giardino_get_tag( get_the_content(), '<blockquote>', '</blockquote>' );
                        if ( ! empty( $quote ) ) {
                            giardino_show_layout( wpautop( $quote ) );
                        } else {
                            the_excerpt();
                        }
                    } elseif ( substr( get_the_content(), 0, 4 ) != '[vc_' ) {
                        the_excerpt();
                    }
                    ?>
                </div>
                <?php
            }
            // Post meta
            if ( in_array( $giardino_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
                if ( ! empty( $giardino_components ) ) {
                    giardino_show_post_meta(
                        apply_filters(
                            'giardino_filter_post_meta_args', array(
                            'components' => $giardino_components,
                            'counters'   => $giardino_counters,
                        ), $giardino_blog_style[0], $giardino_columns
                        )
                    );
                }
            }
            // More button
            if ( false && empty( $giardino_template_args['no_links'] ) && ! in_array( $giardino_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
                ?>
                <p><a class="more-link" href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e( 'Read more', 'giardino' ); ?></a></p>
                <?php
            }
            ?>
        </div><!-- .entry-content -->

    </article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
