<?php
/**
 * Information about this theme
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0.30
 */


// Redirect to the 'About Theme' page after switch theme
if ( ! function_exists( 'giardino_about_after_switch_theme' ) ) {
	add_action( 'after_switch_theme', 'giardino_about_after_switch_theme', 1000 );
	function giardino_about_after_switch_theme() {
		update_option( 'giardino_about_page', 1 );
	}
}
if ( ! function_exists( 'giardino_about_after_setup_theme' ) ) {
	add_action( 'init', 'giardino_about_after_setup_theme', 1000 );
	function giardino_about_after_setup_theme() {
		if ( ! defined( 'WP_CLI' ) && get_option( 'giardino_about_page' ) == 1 ) {
			update_option( 'giardino_about_page', 0 );
			wp_safe_redirect( admin_url() . 'themes.php?page=giardino_about' );
			exit();
		} else {
			if ( giardino_get_value_gp( 'page' ) == 'giardino_about' && giardino_exists_trx_addons() ) {
				wp_safe_redirect( admin_url() . 'admin.php?page=trx_addons_theme_panel' );
				exit();
			}
		}
	}
}


// Add 'About Theme' item in the Appearance menu
if ( ! function_exists( 'giardino_about_add_menu_items' ) ) {
	add_action( 'admin_menu', 'giardino_about_add_menu_items' );
	function giardino_about_add_menu_items() {
		if ( ! giardino_exists_trx_addons() ) {
			$theme      = wp_get_theme();
			$theme_name = $theme->name . ( GIARDINO_THEME_FREE ? ' ' . esc_html__( 'Free', 'giardino' ) : '' );
			add_theme_page(
				// Translators: Add theme name to the page title
				sprintf( esc_html__( 'About %s', 'giardino' ), $theme_name ),    //page_title
				// Translators: Add theme name to the menu title
				sprintf( esc_html__( 'About %s', 'giardino' ), $theme_name ),    //menu_title
				'manage_options',                                               //capability
				'giardino_about',                                                //menu_slug
				'giardino_about_page_builder',                                   //callback
				'dashicons-format-status',                                      //icon
				''                                                              //menu position
			);
		}
	}
}


// Load page-specific scripts and styles
if ( ! function_exists( 'giardino_about_enqueue_scripts' ) ) {
	add_action( 'admin_enqueue_scripts', 'giardino_about_enqueue_scripts' );
	function giardino_about_enqueue_scripts() {
		$screen = function_exists( 'get_current_screen' ) ? get_current_screen() : false;
		if ( ! empty( $screen->id ) && false !== strpos( $screen->id, '_page_giardino_about' ) ) {
			// Scripts
			if ( ! giardino_exists_trx_addons() && function_exists( 'giardino_plugins_installer_enqueue_scripts' ) ) {
				giardino_plugins_installer_enqueue_scripts();
			}
			// Styles
			$fdir = giardino_get_file_url( 'theme-specific/theme-about/theme-about.css' );
			if ( '' != $fdir ) {
				wp_enqueue_style( 'giardino-about', $fdir, array(), null );
			}
		}
	}
}


// Build 'About Theme' page
if ( ! function_exists( 'giardino_about_page_builder' ) ) {
	function giardino_about_page_builder() {
		$theme = wp_get_theme();
		?>
		<div class="giardino_about">

			<?php do_action( 'giardino_action_theme_about_start', $theme ); ?>

			<?php do_action( 'giardino_action_theme_about_before_logo', $theme ); ?>

			<div class="giardino_about_logo">
				<?php
				$logo = giardino_get_file_url( 'theme-specific/theme-about/icon.jpg' );
				if ( empty( $logo ) ) {
					$logo = giardino_get_file_url( 'screenshot.jpg' );
				}
				if ( ! empty( $logo ) ) {
					?>
					<img src="<?php echo esc_url( $logo ); ?>">
					<?php
				}
				?>
			</div>

			<?php do_action( 'giardino_action_theme_about_before_title', $theme ); ?>

			<h1 class="giardino_about_title">
			<?php
				echo esc_html(
					sprintf(
						// Translators: Add theme name and version to the 'Welcome' message
						__( 'Welcome to %1$s %2$s v.%3$s', 'giardino' ),
						$theme->name,
						GIARDINO_THEME_FREE ? esc_html__( 'Free', 'giardino' ) : '',
						$theme->version
					)
				);
			?>
			</h1>

			<?php do_action( 'giardino_action_theme_about_before_description', $theme ); ?>

			<div class="giardino_about_description">
				<p>
					<?php
					echo wp_kses_data( __( 'In order to continue, please install and activate the <b>ThemeREX Addons plugin</b>', 'giardino' ) );
					?>
					<sup>*</sup>
				</p>
			</div>

			<?php do_action( 'giardino_action_theme_about_before_buttons', $theme ); ?>

			<div class="giardino_about_buttons">
				<?php giardino_plugins_installer_get_button_html( 'trx_addons' ); ?>
			</div>

			<?php do_action( 'giardino_action_theme_about_before_buttons', $theme ); ?>

			<div class="giardino_about_notes">
				<p>
					<sup>*</sup>
					<?php
					echo wp_kses_data( __( "<i>ThemeREX Addons plugin</i> will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'giardino' ) );
					?>
				</p>
			</div>

			<?php do_action( 'giardino_action_theme_about_end', $theme ); ?>

		</div>
		<?php
	}
}


// Hide TGMPA notice on the page 'About Theme'
if ( ! function_exists( 'giardino_about_page_disable_tgmpa_notice' ) ) {
	add_filter( 'tgmpa_show_admin_notice_capability', 'giardino_about_page_disable_tgmpa_notice' );
	function giardino_about_page_disable_tgmpa_notice($cap) {
		if ( giardino_get_value_gp( 'page' ) == 'giardino_about' ) {
			$cap = 'unfiltered_upload';
		}
		return $cap;
	}
}

require_once GIARDINO_THEME_DIR . 'includes/plugins-installer/plugins-installer.php';
