<?php
/**
 * Quick Setup Section in the Theme Panel
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0.48
 */


// Load required styles and scripts for admin mode
if ( ! function_exists( 'giardino_options_qsetup_add_scripts' ) ) {
	add_action("admin_enqueue_scripts", 'giardino_options_qsetup_add_scripts');
	function giardino_options_qsetup_add_scripts() {
		if ( ! GIARDINO_THEME_FREE ) {
			$screen = function_exists( 'get_current_screen' ) ? get_current_screen() : false;
			if ( is_object( $screen ) && ! empty( $screen->id ) && false !== strpos($screen->id, 'page_trx_addons_theme_panel') ) {
				wp_enqueue_style( 'fontello-style', giardino_get_file_url( 'css/font-icons/css/fontello-embedded.css' ), array(), null );
				wp_enqueue_script( 'jquery-ui-tabs', false, array( 'jquery', 'jquery-ui-core' ), null, true );
				wp_enqueue_script( 'jquery-ui-accordion', false, array( 'jquery', 'jquery-ui-core' ), null, true );
				wp_enqueue_script( 'giardino-options', giardino_get_file_url( 'theme-options/theme-options.js' ), array( 'jquery' ), null, true );
				wp_localize_script( 'giardino-options', 'giardino_dependencies', giardino_get_theme_dependencies() );
			}
		}
	}
}


// Add step to the 'Quick Setup'
if ( ! function_exists( 'giardino_options_qsetup_theme_panel_steps' ) ) {
	add_filter( 'trx_addons_filter_theme_panel_steps', 'giardino_options_qsetup_theme_panel_steps' );
	function giardino_options_qsetup_theme_panel_steps( $steps ) {
		if ( ! GIARDINO_THEME_FREE ) {
			$steps = giardino_array_merge( $steps, array( 'qsetup' => esc_html__( 'Start customizing your theme.', 'giardino' ) ) );
		}
		return $steps;
	}
}


// Add tab link 'Quick Setup'
if ( ! function_exists( 'giardino_options_qsetup_theme_panel_tabs' ) ) {
	add_filter( 'trx_addons_filter_theme_panel_tabs', 'giardino_options_qsetup_theme_panel_tabs' );
	function giardino_options_qsetup_theme_panel_tabs( $tabs ) {
		if ( ! GIARDINO_THEME_FREE ) {
			$tabs = giardino_array_merge( $tabs, array( 'qsetup' => esc_html__( 'Quick Setup', 'giardino' ) ) );
		}
		return $tabs;
	}
}

// Add accent colors to the 'Quick Setup' section in the Theme Panel
if ( ! function_exists( 'giardino_options_qsetup_add_accent_colors' ) ) {
	add_filter( 'giardino_filter_qsetup_options', 'giardino_options_qsetup_add_accent_colors' );
	function giardino_options_qsetup_add_accent_colors( $options ) {
		return giardino_array_merge(
			array(
				'colors_info'        => array(
					'title'    => esc_html__( 'Theme Colors', 'giardino' ),
					'desc'     => '',
					'qsetup'   => esc_html__( 'General', 'giardino' ),
					'type'     => 'info',
				),
				'colors_text_link'   => array(
					'title'    => esc_html__( 'Accent color 1', 'giardino' ),
					'desc'     => wp_kses_data( __( "Color of the links", 'giardino' ) ),
					'std'      => '',
					'val'      => giardino_get_scheme_color( 'text_link' ),
					'qsetup'   => esc_html__( 'General', 'giardino' ),
					'type'     => 'color',
				),
				'colors_text_hover'  => array(
					'title'    => esc_html__( 'Accent color 1 (hovered state)', 'giardino' ),
					'desc'     => wp_kses_data( __( "Color of the hovered state of the links", 'giardino' ) ),
					'std'      => '',
					'val'      => giardino_get_scheme_color( 'text_hover' ),
					'qsetup'   => esc_html__( 'General', 'giardino' ),
					'type'     => 'color',
				),
				'colors_text_link2'  => array(
					'title'    => esc_html__( 'Accent color 2', 'giardino' ),
					'desc'     => wp_kses_data( __( "Color of the accented areas", 'giardino' ) ),
					'std'      => '',
					'val'      => giardino_get_scheme_color( 'text_link2' ),
					'qsetup'   => esc_html__( 'General', 'giardino' ),
					'type'     => 'color',
				),
				'colors_text_hover2' => array(
					'title'    => esc_html__( 'Accent color 2 (hovered state)', 'giardino' ),
					'desc'     => wp_kses_data( __( "Color of the hovered state of the accented areas", 'giardino' ) ),
					'std'      => '',
					'val'      => giardino_get_scheme_color( 'text_hover2' ),
					'qsetup'   => esc_html__( 'General', 'giardino' ),
					'type'     => 'color',
				),
				'colors_text_link3'  => array(
					'title'    => esc_html__( 'Accent color 3', 'giardino' ),
					'desc'     => wp_kses_data( __( "Color of the another accented areas", 'giardino' ) ),
					'std'      => '',
					'val'      => giardino_get_scheme_color( 'text_link3' ),
					'qsetup'   => esc_html__( 'General', 'giardino' ),
					'type'     => 'color',
				),
				'colors_text_hover3' => array(
					'title'    => esc_html__( 'Accent color 3 (hovered state)', 'giardino' ),
					'desc'     => wp_kses_data( __( "Color of the hovered state of the another accented areas", 'giardino' ) ),
					'std'      => '',
					'val'      => giardino_get_scheme_color( 'text_hover3' ),
					'qsetup'   => esc_html__( 'General', 'giardino' ),
					'type'     => 'color',
				),
			),
			$options
		);
	}
}

// Display 'Quick Setup' section in the Theme Panel
if ( ! function_exists( 'giardino_options_qsetup_theme_panel_section' ) ) {
	add_action( 'trx_addons_action_theme_panel_section', 'giardino_options_qsetup_theme_panel_section', 10, 2);
	function giardino_options_qsetup_theme_panel_section( $tab_id, $theme_info ) {
		if ( 'qsetup' !== $tab_id ) return;
		?>
		<div id="trx_addons_theme_panel_section_<?php echo esc_attr($tab_id); ?>" class="trx_addons_tabs_section">

			<?php do_action('trx_addons_action_theme_panel_section_start', $tab_id, $theme_info); ?>
			
			<div class="trx_addons_theme_panel_qsetup">

				<?php do_action('trx_addons_action_theme_panel_before_section_title', $tab_id, $theme_info); ?>

				<h1 class="trx_addons_theme_panel_section_title">
					<?php esc_html_e( 'Quick Setup', 'giardino' ); ?>
				</h1>

				<?php do_action('trx_addons_action_theme_panel_after_section_title', $tab_id, $theme_info); ?>
				
				<div class="trx_addons_theme_panel_section_info">
					<p>
						<?php
						echo wp_kses_data( __( 'Here you can customize the basic settings of your website.', 'giardino' ) )
							. ' '
							. wp_kses_data( sprintf(
								__( 'For a detailed customization, go to %s.', 'giardino' ),
								'<a href="' . esc_url(admin_url() . 'customize.php') . '">' . esc_html__( 'Customizer', 'giardino' ) . '</a>'
								. ( GIARDINO_THEME_FREE 
									? ''
									: ' ' . esc_html__( 'or', 'giardino' ) . ' ' . '<a href="' . esc_url( get_admin_url( null, 'admin.php?page=trx_addons_theme_panel' ) ) . '">' . esc_html__( 'Theme Options', 'giardino' ) . '</a>'
									)
								)
							);
						?>
					</p>
					<p><?php echo wp_kses_data( __( "<b>Note:</b> If you've imported the demo data, you may skip this step, since all the necessary settings have already been applied.", 'giardino' ) ); ?></p>
				</div>

				<?php
				do_action('trx_addons_action_theme_panel_before_qsetup', $tab_id, $theme_info);

				giardino_options_qsetup_show();

				do_action('trx_addons_action_theme_panel_after_qsetup', $tab_id, $theme_info);
				?>

			</div>

			<?php do_action('trx_addons_action_theme_panel_section_end', $tab_id, $theme_info); ?>

		</div>
		<?php
	}
}


// Display options
if ( ! function_exists( 'giardino_options_qsetup_show' ) ) {
	function giardino_options_qsetup_show() {
		$tabs_titles  = array();
		$tabs_content = array();
		$options      = apply_filters( 'giardino_filter_qsetup_options', giardino_storage_get( 'options' ) );
		// Show fields
		$cnt = 0;
		foreach ( $options as $k => $v ) {
			if ( empty( $v['qsetup'] ) ) {
				continue;
			}
			if ( is_bool( $v['qsetup'] ) ) {
				$v['qsetup'] = esc_html__( 'General', 'giardino' );
			}
			if ( ! isset( $tabs_titles[ $v['qsetup'] ] ) ) {
				$tabs_titles[ $v['qsetup'] ]  = $v['qsetup'];
				$tabs_content[ $v['qsetup'] ] = '';
			}
			if ( 'info' !== $v['type'] ) {
				$cnt++;
				if ( ! empty( $v['class'] ) ) {
					$v['class'] = str_replace( array( 'giardino_column-1_2', 'giardino_new_row' ), '', $v['class'] );
				}
				$v['class'] = ( ! empty( $v['class'] ) ? $v['class'] . ' ' : '' ) . 'giardino_column-1_2' . ( $cnt % 2 == 1 ? ' giardino_new_row' : '' );
			} else {
				$cnt = 0;
			}
			$tabs_content[ $v['qsetup'] ] .= giardino_options_show_field( $k, $v );
		}
		if ( count( $tabs_titles ) > 0 ) {
			?>
			<div class="giardino_options giardino_options_qsetup">
				<form action="<?php echo esc_url( get_admin_url( null, 'admin.php?page=trx_addons_theme_panel' ) ); ?>" class="trx_addons_theme_panel_section_form" name="trx_addons_theme_panel_qsetup_form" method="post">
					<input type="hidden" name="qsetup_options_nonce" value="<?php echo esc_attr( wp_create_nonce( admin_url() ) ); ?>" />
					<?php
					if ( count( $tabs_titles ) > 1 ) {
						?>
						<div id="giardino_options_tabs" class="giardino_tabs">
							<ul>
								<?php
								$cnt = 0;
								foreach ( $tabs_titles as $k => $v ) {
									$cnt++;
									?>
									<li><a href="#giardino_options_<?php echo esc_attr( $cnt ); ?>"><?php echo esc_html( $v ); ?></a></li>
									<?php
								}
								?>
							</ul>
							<?php
							$cnt = 0;
							foreach ( $tabs_content as $k => $v ) {
								$cnt++;
								?>
								<div id="giardino_options_<?php echo esc_attr( $cnt ); ?>" class="giardino_tabs_section giardino_options_section">
									<?php giardino_show_layout( $v ); ?>
								</div>
								<?php
							}
							?>
						</div>
						<?php
					} else {
						?>
						<div class="giardino_options_section">
							<?php giardino_show_layout( giardino_array_get_first( $tabs_content, false ) ); ?>
						</div>
						<?php
					}
					?>
					<div class="giardino_options_buttons trx_buttons">
						<input type="button" class="giardino_options_button_submit button button-action" value="<?php esc_html_e( 'Save Options', 'giardino' ); ?>">
					</div>
				</form>
			</div>
			<?php
		}
	}
}


// Save quick setup options
if ( ! function_exists( 'giardino_options_qsetup_save_options' ) ) {
	add_action( 'after_setup_theme', 'giardino_options_qsetup_save_options', 4 );
	function giardino_options_qsetup_save_options() {

		if ( ! isset( $_REQUEST['page'] ) || 'trx_addons_theme_panel' != $_REQUEST['page'] || '' == giardino_get_value_gp( 'qsetup_options_nonce' ) ) {
			return;
		}

		// verify nonce
		if ( ! wp_verify_nonce( giardino_get_value_gp( 'qsetup_options_nonce' ), admin_url() ) ) {
			trx_addons_set_admin_message( esc_html__( 'Bad security code! Options are not saved!', 'giardino' ), 'error', true );
			return;
		}

		// Check permissions
		if ( ! current_user_can( 'manage_options' ) ) {
			trx_addons_set_admin_message( esc_html__( 'Manage options is denied for the current user! Options are not saved!', 'giardino' ), 'error', true );
			return;
		}

		// Prepare colors for Theme Options
		if ( '' != giardino_get_value_gp( 'giardino_options_field_colors_text_link' ) ) {
			$scheme_storage = get_theme_mod( 'scheme_storage' );
            if ( empty( $scheme_storage ) ) {
                $scheme_storage = giardino_get_scheme_storage();
            }
			if ( ! empty( $scheme_storage ) ) {
				$schemes = giardino_unserialize( $scheme_storage );
				if ( is_array( $schemes ) ) {
					$color_scheme = get_theme_mod( 'color_scheme' );
					if ( empty( $color_scheme ) ) {
						$color_scheme = giardino_array_get_first( $schemes );
					}
					if ( ! empty( $schemes[ $color_scheme] ) ) {
						// Get posted data
						$schemes[ $color_scheme][ 'colors' ][ 'text_link' ]        = giardino_get_value_gp( 'giardino_options_field_colors_text_link' );
						$schemes[ $color_scheme][ 'colors' ][ 'text_hover' ]       = giardino_get_value_gp( 'giardino_options_field_colors_text_hover' );
						$schemes[ $color_scheme][ 'colors' ][ 'text_link2' ]       = giardino_get_value_gp( 'giardino_options_field_colors_text_link2' );
						$schemes[ $color_scheme][ 'colors' ][ 'text_hover2' ]      = giardino_get_value_gp( 'giardino_options_field_colors_text_hover2' );
						$schemes[ $color_scheme][ 'colors' ][ 'text_link3' ]       = giardino_get_value_gp( 'giardino_options_field_colors_text_link3' );
						$schemes[ $color_scheme][ 'colors' ][ 'text_hover3' ]      = giardino_get_value_gp( 'giardino_options_field_colors_text_hover3' );
						// Calculate 'alter' colors
						$schemes[ $color_scheme][ 'colors' ][ 'alter_link' ]       = $schemes[ $color_scheme][ 'colors' ][ 'text_hover' ];
						$schemes[ $color_scheme][ 'colors' ][ 'alter_hover' ]      = $schemes[ $color_scheme][ 'colors' ][ 'text_link' ];
						$schemes[ $color_scheme][ 'colors' ][ 'alter_link2' ]      = $schemes[ $color_scheme][ 'colors' ][ 'text_hover2' ];
						$schemes[ $color_scheme][ 'colors' ][ 'alter_hover2' ]     = $schemes[ $color_scheme][ 'colors' ][ 'text_link2' ];
						$schemes[ $color_scheme][ 'colors' ][ 'alter_link3' ]      = $schemes[ $color_scheme][ 'colors' ][ 'text_hover3' ];
						$schemes[ $color_scheme][ 'colors' ][ 'alter_hover3' ]     = $schemes[ $color_scheme][ 'colors' ][ 'text_link3' ];
						// Calculate 'extra' colors
						$schemes[ $color_scheme][ 'colors' ][ 'extra_link' ]       = $schemes[ $color_scheme][ 'colors' ][ 'text_link' ];
						$schemes[ $color_scheme][ 'colors' ][ 'extra_hover' ]      = $schemes[ $color_scheme][ 'colors' ][ 'text_hover' ];
						$schemes[ $color_scheme][ 'colors' ][ 'extra_link2' ]      = $schemes[ $color_scheme][ 'colors' ][ 'text_link2' ];
						$schemes[ $color_scheme][ 'colors' ][ 'extra_hover2' ]     = $schemes[ $color_scheme][ 'colors' ][ 'text_hover2' ];
						$schemes[ $color_scheme][ 'colors' ][ 'extra_link3' ]      = $schemes[ $color_scheme][ 'colors' ][ 'text_link3' ];
						$schemes[ $color_scheme][ 'colors' ][ 'extra_hover3' ]     = $schemes[ $color_scheme][ 'colors' ][ 'text_hover3' ];
						// Calculate 'inverse' colors
						$hsb                                                       = giardino_hex2hsb( $schemes[ $color_scheme][ 'colors' ][ 'text_link' ] );
						$hsb['b']                                                  = max( 0, $hsb['b'] - 10 );
						$schemes[ $color_scheme][ 'colors' ][ 'inverse_bd_color' ] = giardino_hsb2hex( $hsb );
						$hsb['b']                                                  = max( 0, $hsb['b'] - 10 );
						$schemes[ $color_scheme][ 'colors' ][ 'inverse_bd_hover' ] = giardino_hsb2hex( $hsb );
						// Put new values to the POST
						$_POST['giardino_options_field_scheme_storage']             = serialize( $schemes );
					}
				}
			}
		}

		// Save options
		giardino_options_update( null, 'giardino_options_field_' );

		// Return result
		trx_addons_set_admin_message( esc_html__( 'Options are saved', 'giardino' ), 'success', true );
		wp_redirect( get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_qsetup' ) );
		exit();
	}
}
?>
