<?php
/**
 * The template 'Style 2' to displaying related posts
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

$giardino_link        = get_permalink();
$giardino_post_format = get_post_format();
$giardino_post_format = empty( $giardino_post_format ) ? 'standard' : str_replace( 'post-format-', '', $giardino_post_format );
?><div id="post-<?php the_ID(); ?>" 
	<?php post_class( 'related_item related_item_style_2 post_format_' . esc_attr( $giardino_post_format ) ); ?>>
						<?php
						giardino_show_post_featured(
							array(
								'thumb_size'    => apply_filters( 'giardino_filter_related_thumb_size', giardino_get_thumb_size( (int) giardino_get_theme_option( 'related_posts' ) == 1 ? 'huge' : 'big' ) ),
								'show_no_image' => giardino_get_theme_setting( 'allow_no_image' ),
								'singular'      => false,
							)
						);
						?>
	<div class="post_header entry-header">
	<?php

	if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
		?>
			<span class="post_date"><a href="<?php echo esc_url( $giardino_link ); ?>"><?php echo wp_kses_data( giardino_get_date() ); ?></a></span>
                <div class="footer_likes">
                    <?php
                    // Post meta
                    if ( ! giardino_sc_layouts_showed( 'postmeta' ) && giardino_is_on( giardino_get_theme_option( 'show_post_meta' ) ) ) {
                        giardino_show_post_meta(
                            apply_filters(
                                'giardino_filter_post_meta_args', array(
                                'components' => giardino_array_get_keys_by_value( giardino_get_theme_option( 'meta_parts' ) ),
                                'counters'   => giardino_array_get_keys_by_value( giardino_get_theme_option( 'counters' ) ),
                                'seo'        => false,
                            ), 'single', 1
                            )
                        );
                    }
                    ?>
                </div>
			<?php

	}
	?>
		<h5 class="post_title entry-title"><a href="<?php echo esc_url( $giardino_link ); ?>"><?php the_title(); ?></a></h5>
	</div>
</div>
