<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

// Header sidebar
$giardino_header_name    = giardino_get_theme_option( 'header_widgets' );
$giardino_header_present = ! giardino_is_off( $giardino_header_name ) && is_active_sidebar( $giardino_header_name );
if ( $giardino_header_present ) {
	giardino_storage_set( 'current_sidebar', 'header' );
	$giardino_header_wide = giardino_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $giardino_header_name ) ) {
		dynamic_sidebar( $giardino_header_name );
	}
	$giardino_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $giardino_widgets_output ) ) {
		$giardino_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $giardino_widgets_output );
		$giardino_need_columns   = strpos( $giardino_widgets_output, 'columns_wrap' ) === false;
		if ( $giardino_need_columns ) {
			$giardino_columns = max( 0, (int) giardino_get_theme_option( 'header_columns' ) );
			if ( 0 == $giardino_columns ) {
				$giardino_columns = min( 6, max( 1, substr_count( $giardino_widgets_output, '<aside ' ) ) );
			}
			if ( $giardino_columns > 1 ) {
				$giardino_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $giardino_columns ) . ' widget', $giardino_widgets_output );
			} else {
				$giardino_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $giardino_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $giardino_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $giardino_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'giardino_action_before_sidebar' );
				giardino_show_layout( $giardino_widgets_output );
				do_action( 'giardino_action_after_sidebar' );
				if ( $giardino_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $giardino_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
