<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

// Page (category, tag, archive, author) title

if ( giardino_need_page_title() ) {
	giardino_sc_layouts_showed( 'title', true );
	giardino_sc_layouts_showed( 'postmeta', false );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( false && is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								giardino_show_post_meta(
									apply_filters(
										'giardino_filter_post_meta_args', array(
											'components' => giardino_array_get_keys_by_value( giardino_get_theme_option( 'meta_parts' ) ),
											'counters'   => giardino_array_get_keys_by_value( giardino_get_theme_option( 'counters' ) ),
											'seo'        => giardino_is_on( giardino_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$giardino_blog_title           = giardino_get_blog_title();
							$giardino_blog_title_text      = '';
							$giardino_blog_title_class     = '';
							$giardino_blog_title_link      = '';
							$giardino_blog_title_link_text = '';
							if ( is_array( $giardino_blog_title ) ) {
								$giardino_blog_title_text      = $giardino_blog_title['text'];
								$giardino_blog_title_class     = ! empty( $giardino_blog_title['class'] ) ? ' ' . $giardino_blog_title['class'] : '';
								$giardino_blog_title_link      = ! empty( $giardino_blog_title['link'] ) ? $giardino_blog_title['link'] : '';
								$giardino_blog_title_link_text = ! empty( $giardino_blog_title['link_text'] ) ? $giardino_blog_title['link_text'] : '';
							} else {
								$giardino_blog_title_text = $giardino_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $giardino_blog_title_class ); ?>">
								<?php
								$giardino_top_icon = giardino_get_category_icon();
								if ( ! empty( $giardino_top_icon ) ) {
									$giardino_attr = giardino_getimagesize( $giardino_top_icon );
									?>
									<img src="<?php echo esc_url( $giardino_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'giardino' ); ?>"
										<?php
										if ( ! empty( $giardino_attr[3] ) ) {
											giardino_show_layout( $giardino_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $giardino_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $giardino_blog_title_link ) && ! empty( $giardino_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $giardino_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $giardino_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
                        <?php
                        if ( giardino_exists_trx_addons() ) { // Breadcrumbs ?>
                            <div class="sc_layouts_title_breadcrumbs">
                                <?php
                                do_action( 'giardino_action_breadcrumbs' );
                                ?>
                            </div>
                            <?php
                        }
                        ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>
