<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

$giardino_args = get_query_var( 'giardino_logo_args' );

// Site logo
$giardino_logo_type   = isset( $giardino_args['type'] ) ? $giardino_args['type'] : '';
$giardino_logo_image  = giardino_get_logo_image( $giardino_logo_type );
$giardino_logo_text   = giardino_is_on( giardino_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$giardino_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $giardino_logo_image ) || ! empty( $giardino_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $giardino_logo_image ) ) {
			if ( empty( $giardino_logo_type ) && function_exists( 'the_custom_logo' ) && (int) $giardino_logo_image > 0 ) {
				the_custom_logo();
			} else {
				$giardino_attr = giardino_getimagesize( $giardino_logo_image );
				echo '<img src="' . esc_url( $giardino_logo_image ) . '" alt="' . esc_attr( $giardino_logo_text ) . '"' . ( ! empty( $giardino_attr[3] ) ? ' ' . wp_kses_data( $giardino_attr[3] ) : '' ) . '>';
			}
		} else {
			giardino_show_layout( giardino_prepare_macros( $giardino_logo_text ), '<span class="logo_text">', '</span>' );
			giardino_show_layout( giardino_prepare_macros( $giardino_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
