<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

$giardino_header_css   = '';
$giardino_header_image = get_header_image();
$giardino_header_video = giardino_get_header_video();
if ( ! empty( $giardino_header_image ) && giardino_trx_addons_featured_image_override( is_singular() || giardino_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$giardino_header_image = giardino_get_current_mode_image( $giardino_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $giardino_header_image ) || ! empty( $giardino_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $giardino_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $giardino_header_image ) {
		echo ' ' . esc_attr( giardino_add_inline_css_class( 'background-image: url(' . esc_url( $giardino_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( giardino_is_on( giardino_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight giardino-full-height';
	}
	if ( ! giardino_is_inherit( giardino_get_theme_option( 'header_scheme' ) ) ) {
		echo ' scheme_' . esc_attr( giardino_get_theme_option( 'header_scheme' ) );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $giardino_header_video ) ) {
		get_template_part( apply_filters( 'giardino_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	if ( giardino_get_theme_option( 'menu_style' ) == 'top' ) {
		get_template_part( apply_filters( 'giardino_filter_get_template_part', 'templates/header-navi' ) );
	}

	// Mobile header
	if ( giardino_is_on( giardino_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'giardino_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	get_template_part( apply_filters( 'giardino_filter_get_template_part', 'templates/header-title' ) );

	// Header widgets area
	get_template_part( apply_filters( 'giardino_filter_get_template_part', 'templates/header-widgets' ) );

	// Display featured image in the header on the single posts
	// Comment next line to prevent show featured image in the header area
	// and display it in the post's content
	get_template_part( apply_filters( 'giardino_filter_get_template_part', 'templates/header-single' ) );

	?>
</header>
