<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0.06
 */

$giardino_header_css   = '';
$giardino_header_image = get_header_image();
$giardino_header_video = giardino_get_header_video();
if ( ! empty( $giardino_header_image ) && giardino_trx_addons_featured_image_override( is_singular() || giardino_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$giardino_header_image = giardino_get_current_mode_image( $giardino_header_image );
}

$giardino_header_id = str_replace( 'header-custom-', '', giardino_get_theme_option( 'header_style' ) );
if ( 0 == (int) $giardino_header_id ) {
	$giardino_header_id = giardino_get_post_id(
		array(
			'name'      => $giardino_header_id,
			'post_type' => defined( 'TRX_ADDONS_CPT_LAYOUTS_PT' ) ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts',
		)
	);
} else {
	$giardino_header_id = apply_filters( 'giardino_filter_get_translated_layout', $giardino_header_id );
}
$giardino_header_meta = get_post_meta( $giardino_header_id, 'trx_addons_options', true );
if ( ! empty( $giardino_header_meta['margin'] ) != '' ) {
	giardino_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( giardino_prepare_css_value( $giardino_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $giardino_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $giardino_header_id ) ) ); ?>
				<?php
				echo ! empty( $giardino_header_image ) || ! empty( $giardino_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $giardino_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $giardino_header_image ) {
					echo ' ' . esc_attr( giardino_add_inline_css_class( 'background-image: url(' . esc_url( $giardino_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( giardino_is_on( giardino_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight giardino-full-height';
				}
				if ( ! giardino_is_inherit( giardino_get_theme_option( 'header_scheme' ) ) ) {
					echo ' scheme_' . esc_attr( giardino_get_theme_option( 'header_scheme' ) );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $giardino_header_video ) ) {
		get_template_part( apply_filters( 'giardino_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'giardino_action_show_layout', $giardino_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'giardino_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
