<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0.10
 */

// Footer sidebar
$giardino_footer_name    = giardino_get_theme_option( 'footer_widgets' );
$giardino_footer_present = ! giardino_is_off( $giardino_footer_name ) && is_active_sidebar( $giardino_footer_name );
if ( $giardino_footer_present ) {
	giardino_storage_set( 'current_sidebar', 'footer' );
	$giardino_footer_wide = giardino_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $giardino_footer_name ) ) {
		dynamic_sidebar( $giardino_footer_name );
	}
	$giardino_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $giardino_out ) ) {
		$giardino_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $giardino_out );
		$giardino_need_columns = true;
		if ( $giardino_need_columns ) {
			$giardino_columns = max( 0, (int) giardino_get_theme_option( 'footer_columns' ) );
			if ( 0 == $giardino_columns ) {
				$giardino_columns = min( 4, max( 1, substr_count( $giardino_out, '<aside ' ) ) );
			}
			if ( $giardino_columns > 1 ) {
				$giardino_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $giardino_columns ) . ' widget', $giardino_out );
			} else {
				$giardino_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $giardino_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $giardino_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $giardino_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'giardino_action_before_sidebar' );
				giardino_show_layout( $giardino_out );
				do_action( 'giardino_action_after_sidebar' );
				if ( $giardino_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $giardino_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
