<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0.10
 */

// Logo
if ( giardino_is_on( giardino_get_theme_option( 'logo_in_footer' ) ) ) {
	$giardino_logo_image = giardino_get_logo_image( 'footer' );
	$giardino_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $giardino_logo_image ) || ! empty( $giardino_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $giardino_logo_image ) ) {
					$giardino_attr = giardino_getimagesize( $giardino_logo_image );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $giardino_logo_image ) . '"'
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'giardino' ) . '"'
								. ( ! empty( $giardino_attr[3] ) ? ' ' . wp_kses_data( $giardino_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $giardino_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $giardino_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
