<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0.10
 */

$giardino_footer_id = str_replace( 'footer-custom-', '', giardino_get_theme_option( 'footer_style' ) );
if ( 0 == (int) $giardino_footer_id ) {
	$giardino_footer_id = giardino_get_post_id(
		array(
			'name'      => $giardino_footer_id,
			'post_type' => defined( 'TRX_ADDONS_CPT_LAYOUTS_PT' ) ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts',
		)
	);
} else {
	$giardino_footer_id = apply_filters( 'giardino_filter_get_translated_layout', $giardino_footer_id );
}
$giardino_footer_meta = get_post_meta( $giardino_footer_id, 'trx_addons_options', true );
if ( ! empty( $giardino_footer_meta['margin'] ) != '' ) {
	giardino_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( giardino_prepare_css_value( $giardino_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $giardino_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $giardino_footer_id ) ) ); ?>
						<?php
						if ( ! giardino_is_inherit( giardino_get_theme_option( 'footer_scheme' ) ) ) {
							echo ' scheme_' . esc_attr( giardino_get_theme_option( 'footer_scheme' ) );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'giardino_action_show_layout', $giardino_footer_id );
	?>
</footer><!-- /.footer_wrap -->
