<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
if ( ! giardino_is_inherit( giardino_get_theme_option( 'copyright_scheme' ) ) ) {
	echo ' scheme_' . esc_attr( giardino_get_theme_option( 'copyright_scheme' ) );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$giardino_copyright = giardino_get_theme_option( 'copyright' );
			if ( ! empty( $giardino_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$giardino_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $giardino_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$giardino_copyright = giardino_prepare_macros( $giardino_copyright );
				// Display copyright
				echo wp_kses_post( nl2br( $giardino_copyright ) );
			}
			?>
			</div>
		</div>
	</div>
</div>
