<?php
/**
 * The template to display the Author bio
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */
?>

<div class="author_info scheme_dark author vcard" itemprop="author" itemscope itemtype="http://schema.org/Person">

	<div class="author_avatar" itemprop="image">
		<?php
		$giardino_mult = giardino_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120 * $giardino_mult );
		?>
	</div><!-- .author_avatar -->

	<div class="author_description">
        <p> <?php
            // Translators: Add the author's name in the <span>
            echo esc_html__('About Author', 'giardino')
            ?>
        </p>
		<h5 class="author_title" itemprop="name">
		<?php
			// Translators: Add the author's name in the <span>
			echo wp_kses_data( sprintf( __( '%s', 'giardino' ), '<span class="fn">' . get_the_author() . '</span>' ) );
		?>
		</h5>

		<div class="author_bio" itemprop="description">
			<?php echo wp_kses_post( wpautop( get_the_author_meta( 'description' ) ) ); ?>
			<?php do_action( 'giardino_action_user_meta' ); ?>
		</div><!-- .author_bio -->

	</div><!-- .author_description -->

</div><!-- .author_info -->
