<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0.1
 */

$giardino_theme_obj = wp_get_theme();
?>
<div class="giardino_admin_notice giardino_welcome_notice update-nag">
	<?php
	// Theme image
	$giardino_theme_img = giardino_get_file_url( 'screenshot.jpg' );
	if ( '' != $giardino_theme_img ) {
		?>
		<div class="giardino_notice_image"><img src="<?php echo esc_url( $giardino_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'giardino' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="giardino_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
                __( 'Welcome to %1$s v.%2$s', 'giardino' ),
				$giardino_theme_obj->name . ( GIARDINO_THEME_FREE ? ' ' . __( 'Free', 'giardino' ) : '' ),
				$giardino_theme_obj->version
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="giardino_notice_text">
		<p class="giardino_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $giardino_theme_obj->description ) );
			?>
		</p>
		<p class="giardino_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'giardino' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="giardino_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=giardino_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'giardino' );
			?>
		</a>
		<?php		
		// Dismiss this notice
		?>
		<a href="#" class="giardino_hide_notice"><i class="dashicons dashicons-dismiss"></i> <span class="giardino_hide_notice_text"><?php esc_html_e( 'Dismiss', 'giardino' ); ?></span></a>
	</div>
</div>
