<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

if ( giardino_sidebar_present() ) {
	ob_start();
	$giardino_sidebar_name = giardino_get_theme_option( 'sidebar_widgets' );
	giardino_storage_set( 'current_sidebar', 'sidebar' );
	if ( is_active_sidebar( $giardino_sidebar_name ) ) {
		dynamic_sidebar( $giardino_sidebar_name );
	}
	$giardino_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $giardino_out ) ) {
		$giardino_sidebar_position = giardino_get_theme_option( 'sidebar_position' );
		?>
		<div class="sidebar widget_area
			<?php
			echo esc_attr( $giardino_sidebar_position );
			if ( ! giardino_is_inherit( giardino_get_theme_option( 'sidebar_scheme' ) ) ) {
				echo ' scheme_' . esc_attr( giardino_get_theme_option( 'sidebar_scheme' ) );
			}
			?>
		" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'giardino_action_before_sidebar' );
				giardino_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $giardino_out ) );
				do_action( 'giardino_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<div class="clearfix"></div>
		<?php
	}
}
