<?php
/* Table Reservations support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'giardino_table_reservations_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'giardino_table_reservations_theme_setup9', 9 );
    function giardino_table_reservations_theme_setup9() {

        if ( is_admin() ) {
            add_filter( 'giardino_filter_tgmpa_required_plugins', 'giardino_table_reservations_tgmpa_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'giardino_table_reservations_tgmpa_required_plugins' ) ) {
    //Handler of the add_filter('giardino_filter_tgmpa_required_plugins',	'giardino_table_reservationsd_tgmpa_required_plugins');
    function giardino_table_reservations_tgmpa_required_plugins( $list = array() ) {
        if ( giardino_storage_isset( 'required_plugins', 'table-reservations' ) && giardino_is_theme_activated() ) {
            $path = giardino_get_plugin_source_path( 'plugins/table-reservations/table-reservations.zip' );
            if ( ! empty( $path ) || giardino_get_theme_setting( 'tgmpa_upload' ) ) {
                $list[] = array(
                    'name'     => giardino_storage_get_array( 'required_plugins', 'table-reservations' ),
                    'slug'     => 'table-reservations',
                    'source'   => ! empty( $path ) ? $path : 'upload://table-reservations.zip',
                    'version'  => '3.3.3',
                    'required' => false,
                );
            }
        }
        return $list;
    }
}

