<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'giardino_essential_grid_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'giardino_essential_grid_theme_setup9', 9 );
	function giardino_essential_grid_theme_setup9() {

		add_filter( 'giardino_filter_merge_styles', 'giardino_essential_grid_merge_styles' );

		if ( is_admin() ) {
			add_filter( 'giardino_filter_tgmpa_required_plugins', 'giardino_essential_grid_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'giardino_essential_grid_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('giardino_filter_tgmpa_required_plugins',	'giardino_essential_grid_tgmpa_required_plugins');
	function giardino_essential_grid_tgmpa_required_plugins( $list = array() ) {
		if ( giardino_storage_isset( 'required_plugins', 'essential-grid' ) && giardino_is_theme_activated() ) {
			$path = giardino_get_plugin_source_path( 'plugins/essential-grid/essential-grid.zip' );
			if ( ! empty( $path ) || giardino_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => giardino_storage_get_array( 'required_plugins', 'essential-grid' ),
					'slug'     => 'essential-grid',
					'source'   => ! empty( $path ) ? $path : 'upload://essential-grid.zip',
					'version'  => '2.3.2',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'giardino_exists_essential_grid' ) ) {
	function giardino_exists_essential_grid() {
		return defined( 'EG_PLUGIN_PATH' );
	}
}

// Merge custom styles
if ( ! function_exists( 'giardino_essential_grid_merge_styles' ) ) {
	//Handler of the add_filter('giardino_filter_merge_styles', 'giardino_essential_grid_merge_styles');
	function giardino_essential_grid_merge_styles( $list ) {
		if ( giardino_exists_essential_grid() ) {
			$list[] = 'plugins/essential-grid/_essential-grid.scss';
		}
		return $list;
	}
}

