<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'giardino_cf7_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'giardino_cf7_theme_setup9', 9 );
	function giardino_cf7_theme_setup9() {

		add_filter( 'giardino_filter_merge_scripts', 'giardino_cf7_merge_scripts' );
		add_filter( 'giardino_filter_merge_styles', 'giardino_cf7_merge_styles' );

		if ( giardino_exists_cf7() ) {
			add_action( 'wp_enqueue_scripts', 'giardino_cf7_frontend_scripts', 1100 );
		}

		if ( is_admin() ) {
			add_filter( 'giardino_filter_tgmpa_required_plugins', 'giardino_cf7_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'giardino_cf7_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('giardino_filter_tgmpa_required_plugins',	'giardino_cf7_tgmpa_required_plugins');
	function giardino_cf7_tgmpa_required_plugins( $list = array() ) {
		if ( giardino_storage_isset( 'required_plugins', 'contact-form-7' ) ) {
			// CF7 plugin
			$list[] = array(
				'name'     => giardino_storage_get_array( 'required_plugins', 'contact-form-7' ),
				'slug'     => 'contact-form-7',
				'required' => false,
			);
		}
		return $list;
	}
}



// Check if cf7 installed and activated
if ( ! function_exists( 'giardino_exists_cf7' ) ) {
	function giardino_exists_cf7() {
		return class_exists( 'WPCF7' );
	}
}

// Enqueue custom scripts
if ( ! function_exists( 'giardino_cf7_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'giardino_cf7_frontend_scripts', 1100 );
	function giardino_cf7_frontend_scripts() {
		if ( giardino_exists_cf7() ) {
			if ( giardino_is_on( giardino_get_theme_option( 'debug_mode' ) ) ) {
				$giardino_url = giardino_get_file_url( 'plugins/contact-form-7/contact-form-7.js' );
				if ( '' != $giardino_url ) {
					wp_enqueue_script( 'giardino-cf7', $giardino_url, array( 'jquery' ), null, true );
				}
			}
		}
	}
}

// Merge custom scripts
if ( ! function_exists( 'giardino_cf7_merge_scripts' ) ) {
	//Handler of the add_filter('giardino_filter_merge_scripts', 'giardino_cf7_merge_scripts');
	function giardino_cf7_merge_scripts( $list ) {
		if ( giardino_exists_cf7() ) {
			$list[] = 'plugins/contact-form-7/contact-form-7.js';
		}
		return $list;
	}
}

// Merge custom styles
if ( ! function_exists( 'giardino_cf7_merge_styles' ) ) {
	//Handler of the add_filter('giardino_filter_merge_styles', 'giardino_cf7_merge_styles');
	function giardino_cf7_merge_styles( $list ) {
		if ( giardino_exists_cf7() ) {
			$list[] = 'plugins/contact-form-7/_contact-form-7.scss';
		}
		return $list;
	}
}

