<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

giardino_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	giardino_blog_archive_start();

	$giardino_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$giardino_sticky_out = giardino_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $giardino_stickies ) && count( $giardino_stickies ) > 0 && get_query_var( 'paged' ) < 1;

	// Show filters
	$giardino_cat          = giardino_get_theme_option( 'parent_cat' );
	$giardino_post_type    = giardino_get_theme_option( 'post_type' );
	$giardino_taxonomy     = giardino_get_post_type_taxonomy( $giardino_post_type );
	$giardino_show_filters = giardino_get_theme_option( 'show_filters' );
	$giardino_tabs         = array();
	if ( ! giardino_is_off( $giardino_show_filters ) ) {
		$giardino_args           = array(
			'type'         => $giardino_post_type,
			'child_of'     => $giardino_cat,
			'orderby'      => 'name',
			'order'        => 'ASC',
			'hide_empty'   => 1,
			'hierarchical' => 0,
			'taxonomy'     => $giardino_taxonomy,
			'pad_counts'   => false,
		);
		$giardino_portfolio_list = get_terms( $giardino_args );
		if ( is_array( $giardino_portfolio_list ) && count( $giardino_portfolio_list ) > 0 ) {
			$giardino_tabs[ $giardino_cat ] = esc_html__( 'All', 'giardino' );
			foreach ( $giardino_portfolio_list as $giardino_term ) {
				if ( isset( $giardino_term->term_id ) ) {
					$giardino_tabs[ $giardino_term->term_id ] = $giardino_term->name;
				}
			}
		}
	}
	if ( count( $giardino_tabs ) > 0 ) {
		$giardino_portfolio_filters_ajax   = true;
		$giardino_portfolio_filters_active = $giardino_cat;
		$giardino_portfolio_filters_id     = 'portfolio_filters';
		?>
		<div class="portfolio_filters giardino_tabs giardino_tabs_ajax">
			<ul class="portfolio_titles giardino_tabs_titles">
				<?php
				foreach ( $giardino_tabs as $giardino_id => $giardino_title ) {
					?>
					<li><a href="<?php echo esc_url( giardino_get_hash_link( sprintf( '#%s_%s_content', $giardino_portfolio_filters_id, $giardino_id ) ) ); ?>" data-tab="<?php echo esc_attr( $giardino_id ); ?>"><?php echo esc_html( $giardino_title ); ?></a></li>
					<?php
				}
				?>
			</ul>
			<?php
			$giardino_ppp = giardino_get_theme_option( 'posts_per_page' );
			if ( giardino_is_inherit( $giardino_ppp ) ) {
				$giardino_ppp = '';
			}
			foreach ( $giardino_tabs as $giardino_id => $giardino_title ) {
				$giardino_portfolio_need_content = $giardino_id == $giardino_portfolio_filters_active || ! $giardino_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr( sprintf( '%s_%s_content', $giardino_portfolio_filters_id, $giardino_id ) ); ?>"
					class="portfolio_content giardino_tabs_content"
					data-blog-template="<?php echo esc_attr( giardino_storage_get( 'blog_template' ) ); ?>"
					data-blog-style="<?php echo esc_attr( giardino_get_theme_option( 'blog_style' ) ); ?>"
					data-posts-per-page="<?php echo esc_attr( $giardino_ppp ); ?>"
					data-post-type="<?php echo esc_attr( $giardino_post_type ); ?>"
					data-taxonomy="<?php echo esc_attr( $giardino_taxonomy ); ?>"
					data-cat="<?php echo esc_attr( $giardino_id ); ?>"
					data-parent-cat="<?php echo esc_attr( $giardino_cat ); ?>"
					data-need-content="<?php echo ( false === $giardino_portfolio_need_content ? 'true' : 'false' ); ?>"
				>
					<?php
					if ( $giardino_portfolio_need_content ) {
						giardino_show_portfolio_posts(
							array(
								'cat'        => $giardino_id,
								'parent_cat' => $giardino_cat,
								'taxonomy'   => $giardino_taxonomy,
								'post_type'  => $giardino_post_type,
								'page'       => 1,
								'sticky'     => $giardino_sticky_out,
							)
						);
					}
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		giardino_show_portfolio_posts(
			array(
				'cat'        => $giardino_cat,
				'parent_cat' => $giardino_cat,
				'taxonomy'   => $giardino_taxonomy,
				'post_type'  => $giardino_post_type,
				'page'       => 1,
				'sticky'     => $giardino_sticky_out,
			)
		);
	}

	giardino_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'giardino_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'giardino_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
