<?php
/**
 * The template for homepage posts with "Chess" style
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

giardino_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	giardino_blog_archive_start();

	$giardino_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$giardino_sticky_out = giardino_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $giardino_stickies ) && count( $giardino_stickies ) > 0 && get_query_var( 'paged' ) < 1;
	if ( $giardino_sticky_out ) {
		?>
		<div class="sticky_wrap columns_wrap">
		<?php
	}
	if ( ! $giardino_sticky_out ) {
		?>
		<div class="chess_wrap posts_container">
		<?php
	}
	while ( have_posts() ) {
		the_post();
		if ( $giardino_sticky_out && ! is_sticky() ) {
			$giardino_sticky_out = false;
			?>
			</div><div class="chess_wrap posts_container">
			<?php
		}
		$giardino_part = $giardino_sticky_out && is_sticky() ? 'sticky' : 'chess';
		get_template_part( apply_filters( 'giardino_filter_get_template_part', 'content', $giardino_part ), $giardino_part );
	}

	?>
	</div>
	<?php

	giardino_show_pagination();

	giardino_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'giardino_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'giardino_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
