<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) {
	exit; }

// Get theme variable
if ( ! function_exists( 'giardino_storage_get' ) ) {
	function giardino_storage_get( $var_name, $default = '' ) {
		global $GIARDINO_STORAGE;
		return isset( $GIARDINO_STORAGE[ $var_name ] ) ? $GIARDINO_STORAGE[ $var_name ] : $default;
	}
}

// Set theme variable
if ( ! function_exists( 'giardino_storage_set' ) ) {
	function giardino_storage_set( $var_name, $value ) {
		global $GIARDINO_STORAGE;
		$GIARDINO_STORAGE[ $var_name ] = $value;
	}
}

// Check if theme variable is empty
if ( ! function_exists( 'giardino_storage_empty' ) ) {
	function giardino_storage_empty( $var_name, $key = '', $key2 = '' ) {
		global $GIARDINO_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return empty( $GIARDINO_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return empty( $GIARDINO_STORAGE[ $var_name ][ $key ] );
		} else {
			return empty( $GIARDINO_STORAGE[ $var_name ] );
		}
	}
}

// Check if theme variable is set
if ( ! function_exists( 'giardino_storage_isset' ) ) {
	function giardino_storage_isset( $var_name, $key = '', $key2 = '' ) {
		global $GIARDINO_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return isset( $GIARDINO_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return isset( $GIARDINO_STORAGE[ $var_name ][ $key ] );
		} else {
			return isset( $GIARDINO_STORAGE[ $var_name ] );
		}
	}
}

// Inc/Dec theme variable with specified value
if ( ! function_exists( 'giardino_storage_inc' ) ) {
	function giardino_storage_inc( $var_name, $value = 1 ) {
		global $GIARDINO_STORAGE;
		if ( empty( $GIARDINO_STORAGE[ $var_name ] ) ) {
			$GIARDINO_STORAGE[ $var_name ] = 0;
		}
		$GIARDINO_STORAGE[ $var_name ] += $value;
	}
}

// Concatenate theme variable with specified value
if ( ! function_exists( 'giardino_storage_concat' ) ) {
	function giardino_storage_concat( $var_name, $value ) {
		global $GIARDINO_STORAGE;
		if ( empty( $GIARDINO_STORAGE[ $var_name ] ) ) {
			$GIARDINO_STORAGE[ $var_name ] = '';
		}
		$GIARDINO_STORAGE[ $var_name ] .= $value;
	}
}

// Get array (one or two dim) element
if ( ! function_exists( 'giardino_storage_get_array' ) ) {
	function giardino_storage_get_array( $var_name, $key, $key2 = '', $default = '' ) {
		global $GIARDINO_STORAGE;
		if ( empty( $key2 ) ) {
			return ! empty( $var_name ) && ! empty( $key ) && isset( $GIARDINO_STORAGE[ $var_name ][ $key ] ) ? $GIARDINO_STORAGE[ $var_name ][ $key ] : $default;
		} else {
			return ! empty( $var_name ) && ! empty( $key ) && isset( $GIARDINO_STORAGE[ $var_name ][ $key ][ $key2 ] ) ? $GIARDINO_STORAGE[ $var_name ][ $key ][ $key2 ] : $default;
		}
	}
}

// Set array element
if ( ! function_exists( 'giardino_storage_set_array' ) ) {
	function giardino_storage_set_array( $var_name, $key, $value ) {
		global $GIARDINO_STORAGE;
		if ( ! isset( $GIARDINO_STORAGE[ $var_name ] ) ) {
			$GIARDINO_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$GIARDINO_STORAGE[ $var_name ][] = $value;
		} else {
			$GIARDINO_STORAGE[ $var_name ][ $key ] = $value;
		}
	}
}

// Set two-dim array element
if ( ! function_exists( 'giardino_storage_set_array2' ) ) {
	function giardino_storage_set_array2( $var_name, $key, $key2, $value ) {
		global $GIARDINO_STORAGE;
		if ( ! isset( $GIARDINO_STORAGE[ $var_name ] ) ) {
			$GIARDINO_STORAGE[ $var_name ] = array();
		}
		if ( ! isset( $GIARDINO_STORAGE[ $var_name ][ $key ] ) ) {
			$GIARDINO_STORAGE[ $var_name ][ $key ] = array();
		}
		if ( '' === $key2 ) {
			$GIARDINO_STORAGE[ $var_name ][ $key ][] = $value;
		} else {
			$GIARDINO_STORAGE[ $var_name ][ $key ][ $key2 ] = $value;
		}
	}
}

// Merge array elements
if ( ! function_exists( 'giardino_storage_merge_array' ) ) {
	function giardino_storage_merge_array( $var_name, $key, $value ) {
		global $GIARDINO_STORAGE;
		if ( ! isset( $GIARDINO_STORAGE[ $var_name ] ) ) {
			$GIARDINO_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$GIARDINO_STORAGE[ $var_name ] = array_merge( $GIARDINO_STORAGE[ $var_name ], $value );
		} else {
			$GIARDINO_STORAGE[ $var_name ][ $key ] = array_merge( $GIARDINO_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Add array element after the key
if ( ! function_exists( 'giardino_storage_set_array_after' ) ) {
	function giardino_storage_set_array_after( $var_name, $after, $key, $value = '' ) {
		global $GIARDINO_STORAGE;
		if ( ! isset( $GIARDINO_STORAGE[ $var_name ] ) ) {
			$GIARDINO_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			giardino_array_insert_after( $GIARDINO_STORAGE[ $var_name ], $after, $key );
		} else {
			giardino_array_insert_after( $GIARDINO_STORAGE[ $var_name ], $after, array( $key => $value ) );
		}
	}
}

// Add array element before the key
if ( ! function_exists( 'giardino_storage_set_array_before' ) ) {
	function giardino_storage_set_array_before( $var_name, $before, $key, $value = '' ) {
		global $GIARDINO_STORAGE;
		if ( ! isset( $GIARDINO_STORAGE[ $var_name ] ) ) {
			$GIARDINO_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			giardino_array_insert_before( $GIARDINO_STORAGE[ $var_name ], $before, $key );
		} else {
			giardino_array_insert_before( $GIARDINO_STORAGE[ $var_name ], $before, array( $key => $value ) );
		}
	}
}

// Push element into array
if ( ! function_exists( 'giardino_storage_push_array' ) ) {
	function giardino_storage_push_array( $var_name, $key, $value ) {
		global $GIARDINO_STORAGE;
		if ( ! isset( $GIARDINO_STORAGE[ $var_name ] ) ) {
			$GIARDINO_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			array_push( $GIARDINO_STORAGE[ $var_name ], $value );
		} else {
			if ( ! isset( $GIARDINO_STORAGE[ $var_name ][ $key ] ) ) {
				$GIARDINO_STORAGE[ $var_name ][ $key ] = array();
			}
			array_push( $GIARDINO_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Pop element from array
if ( ! function_exists( 'giardino_storage_pop_array' ) ) {
	function giardino_storage_pop_array( $var_name, $key = '', $defa = '' ) {
		global $GIARDINO_STORAGE;
		$rez = $defa;
		if ( '' === $key ) {
			if ( isset( $GIARDINO_STORAGE[ $var_name ] ) && is_array( $GIARDINO_STORAGE[ $var_name ] ) && count( $GIARDINO_STORAGE[ $var_name ] ) > 0 ) {
				$rez = array_pop( $GIARDINO_STORAGE[ $var_name ] );
			}
		} else {
			if ( isset( $GIARDINO_STORAGE[ $var_name ][ $key ] ) && is_array( $GIARDINO_STORAGE[ $var_name ][ $key ] ) && count( $GIARDINO_STORAGE[ $var_name ][ $key ] ) > 0 ) {
				$rez = array_pop( $GIARDINO_STORAGE[ $var_name ][ $key ] );
			}
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if ( ! function_exists( 'giardino_storage_inc_array' ) ) {
	function giardino_storage_inc_array( $var_name, $key, $value = 1 ) {
		global $GIARDINO_STORAGE;
		if ( ! isset( $GIARDINO_STORAGE[ $var_name ] ) ) {
			$GIARDINO_STORAGE[ $var_name ] = array();
		}
		if ( empty( $GIARDINO_STORAGE[ $var_name ][ $key ] ) ) {
			$GIARDINO_STORAGE[ $var_name ][ $key ] = 0;
		}
		$GIARDINO_STORAGE[ $var_name ][ $key ] += $value;
	}
}

// Concatenate array element with specified value
if ( ! function_exists( 'giardino_storage_concat_array' ) ) {
	function giardino_storage_concat_array( $var_name, $key, $value ) {
		global $GIARDINO_STORAGE;
		if ( ! isset( $GIARDINO_STORAGE[ $var_name ] ) ) {
			$GIARDINO_STORAGE[ $var_name ] = array();
		}
		if ( empty( $GIARDINO_STORAGE[ $var_name ][ $key ] ) ) {
			$GIARDINO_STORAGE[ $var_name ][ $key ] = '';
		}
		$GIARDINO_STORAGE[ $var_name ][ $key ] .= $value;
	}
}

// Call object's method
if ( ! function_exists( 'giardino_storage_call_obj_method' ) ) {
	function giardino_storage_call_obj_method( $var_name, $method, $param = null ) {
		global $GIARDINO_STORAGE;
		if ( null === $param ) {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $GIARDINO_STORAGE[ $var_name ] ) ? $GIARDINO_STORAGE[ $var_name ]->$method() : '';
		} else {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $GIARDINO_STORAGE[ $var_name ] ) ? $GIARDINO_STORAGE[ $var_name ]->$method( $param ) : '';
		}
	}
}

// Get object's property
if ( ! function_exists( 'giardino_storage_get_obj_property' ) ) {
	function giardino_storage_get_obj_property( $var_name, $prop, $default = '' ) {
		global $GIARDINO_STORAGE;
		return ! empty( $var_name ) && ! empty( $prop ) && isset( $GIARDINO_STORAGE[ $var_name ]->$prop ) ? $GIARDINO_STORAGE[ $var_name ]->$prop : $default;
	}
}
