<?php
/**
 * The Header: Logo and main menu
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js
									<?php
										// Class scheme_xxx need in the <html> as context for the <body>!
										echo ' scheme_' . esc_attr( giardino_get_theme_option( 'color_scheme' ) );
									?>
										">
<head>
	<?php wp_head(); ?>
</head>

<body <?php	body_class(); ?>>

	<?php do_action( 'giardino_action_before_body' ); ?>

	<div class="body_wrap">

		<div class="page_wrap">
			<?php
			// Desktop header
			$giardino_header_type = giardino_get_theme_option( 'header_type' );
			if ( 'custom' == $giardino_header_type && ! giardino_is_layouts_available() ) {
				$giardino_header_type = 'default';
			}
			get_template_part( apply_filters( 'giardino_filter_get_template_part', "templates/header-{$giardino_header_type}" ) );

			// Side menu
			if ( in_array( giardino_get_theme_option( 'menu_style' ), array( 'left', 'right' ) ) ) {
				get_template_part( apply_filters( 'giardino_filter_get_template_part', 'templates/header-navi-side' ) );
			}

			// Mobile menu
			get_template_part( apply_filters( 'giardino_filter_get_template_part', 'templates/header-navi-mobile' ) );
			?>

			<div class="page_content_wrap">

				<?php if ( giardino_get_theme_option( 'body_style' ) != 'fullscreen' ) { ?>
				<div class="content_wrap">
				<?php } ?>

					<?php
					// Widgets area above page content
					giardino_create_widgets_area( 'widgets_above_page' );
					?>

					<div class="content">
						<?php
						// Widgets area inside page content
						giardino_create_widgets_area( 'widgets_above_content' );
