<?php
$giardino_slider_sc = giardino_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $giardino_slider_sc ) && strpos( $giardino_slider_sc, '[' ) !== false && strpos( $giardino_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider">
	<?php
		// Add anchor
		$giardino_anchor_icon = giardino_get_theme_option( 'front_page_title_anchor_icon' );
		$giardino_anchor_text = giardino_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $giardino_anchor_icon ) || ! empty( $giardino_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $giardino_anchor_icon ) ? ' icon="' . esc_attr( $giardino_anchor_icon ) . '"' : '' )
									. ( ! empty( $giardino_anchor_text ) ? ' title="' . esc_attr( $giardino_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $giardino_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$giardino_scheme = giardino_get_theme_option( 'front_page_title_scheme' );
		if ( ! giardino_is_inherit( $giardino_scheme ) ) {
			echo ' scheme_' . esc_attr( $giardino_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( giardino_get_theme_option( 'front_page_title_paddings' ) );
		?>
		"
		<?php
		$giardino_css      = '';
		$giardino_bg_image = giardino_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $giardino_bg_image ) ) {
			$giardino_css .= 'background-image: url(' . esc_url( giardino_get_attachment_url( $giardino_bg_image ) ) . ');';
		}
		if ( ! empty( $giardino_css ) ) {
			echo ' style="' . esc_attr( $giardino_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$giardino_anchor_icon = giardino_get_theme_option( 'front_page_title_anchor_icon' );
		$giardino_anchor_text = giardino_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $giardino_anchor_icon ) || ! empty( $giardino_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $giardino_anchor_icon ) ? ' icon="' . esc_attr( $giardino_anchor_icon ) . '"' : '' )
									. ( ! empty( $giardino_anchor_text ) ? ' title="' . esc_attr( $giardino_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( giardino_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' giardino-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$giardino_css      = '';
			$giardino_bg_mask  = giardino_get_theme_option( 'front_page_title_bg_mask' );
			$giardino_bg_color_type = giardino_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $giardino_bg_color_type ) {
				$giardino_bg_color = giardino_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $giardino_bg_color_type ) {
				$giardino_bg_color = giardino_get_scheme_color( 'bg_color', $giardino_scheme );
			} else {
				$giardino_bg_color = '';
			}
			if ( ! empty( $giardino_bg_color ) && $giardino_bg_mask > 0 ) {
				$giardino_css .= 'background-color: ' . esc_attr(
					1 == $giardino_bg_mask ? $giardino_bg_color : giardino_hex2rgba( $giardino_bg_color, $giardino_bg_mask )
				) . ';';
			}
			if ( ! empty( $giardino_css ) ) {
				echo ' style="' . esc_attr( $giardino_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$giardino_caption = giardino_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $giardino_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $giardino_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses_post( $giardino_caption ); ?></h1>
					<?php
				}

				// Description (text)
				$giardino_description = giardino_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $giardino_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $giardino_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses_post( wpautop( $giardino_description ) ); ?></div>
					<?php
				}

				// Buttons
				if ( giardino_get_theme_option( 'front_page_title_button1_link' ) != '' || giardino_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						giardino_show_layout( giardino_customizer_partial_refresh_front_page_title_button1_link() );
						giardino_show_layout( giardino_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
