<div class="front_page_section front_page_section_contacts<?php
	$giardino_scheme = giardino_get_theme_option( 'front_page_contacts_scheme' );
	if ( ! giardino_is_inherit( $giardino_scheme ) ) {
		echo ' scheme_' . esc_attr( $giardino_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( giardino_get_theme_option( 'front_page_contacts_paddings' ) );
?>"
		<?php
		$giardino_css      = '';
		$giardino_bg_image = giardino_get_theme_option( 'front_page_contacts_bg_image' );
		if ( ! empty( $giardino_bg_image ) ) {
			$giardino_css .= 'background-image: url(' . esc_url( giardino_get_attachment_url( $giardino_bg_image ) ) . ');';
		}
		if ( ! empty( $giardino_css ) ) {
			echo ' style="' . esc_attr( $giardino_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$giardino_anchor_icon = giardino_get_theme_option( 'front_page_contacts_anchor_icon' );
	$giardino_anchor_text = giardino_get_theme_option( 'front_page_contacts_anchor_text' );
if ( ( ! empty( $giardino_anchor_icon ) || ! empty( $giardino_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_contacts"'
									. ( ! empty( $giardino_anchor_icon ) ? ' icon="' . esc_attr( $giardino_anchor_icon ) . '"' : '' )
									. ( ! empty( $giardino_anchor_text ) ? ' title="' . esc_attr( $giardino_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_contacts_inner
	<?php
	if ( giardino_get_theme_option( 'front_page_contacts_fullheight' ) ) {
		echo ' giardino-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$giardino_css      = '';
			$giardino_bg_mask  = giardino_get_theme_option( 'front_page_contacts_bg_mask' );
			$giardino_bg_color_type = giardino_get_theme_option( 'front_page_contacts_bg_color_type' );
			if ( 'custom' == $giardino_bg_color_type ) {
				$giardino_bg_color = giardino_get_theme_option( 'front_page_contacts_bg_color' );
			} elseif ( 'scheme_bg_color' == $giardino_bg_color_type ) {
				$giardino_bg_color = giardino_get_scheme_color( 'bg_color', $giardino_scheme );
			} else {
				$giardino_bg_color = '';
			}
			if ( ! empty( $giardino_bg_color ) && $giardino_bg_mask > 0 ) {
				$giardino_css .= 'background-color: ' . esc_attr(
					1 == $giardino_bg_mask ? $giardino_bg_color : giardino_hex2rgba( $giardino_bg_color, $giardino_bg_mask )
				) . ';';
			}
			if ( ! empty( $giardino_css ) ) {
				echo ' style="' . esc_attr( $giardino_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_contacts_content_wrap content_wrap">
			<?php

			// Title and description
			$giardino_caption     = giardino_get_theme_option( 'front_page_contacts_caption' );
			$giardino_description = giardino_get_theme_option( 'front_page_contacts_description' );
			if ( ! empty( $giardino_caption ) || ! empty( $giardino_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $giardino_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_contacts_caption front_page_block_<?php echo ! empty( $giardino_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses_post( $giardino_caption );
					?>
					</h2>
					<?php
				}

				// Description
				if ( ! empty( $giardino_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_contacts_description front_page_block_<?php echo ! empty( $giardino_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses_post( wpautop( $giardino_description ) );
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$giardino_content = giardino_get_theme_option( 'front_page_contacts_content' );
			$giardino_layout  = giardino_get_theme_option( 'front_page_contacts_layout' );
			if ( 'columns' == $giardino_layout && ( ! empty( $giardino_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_columns front_page_section_contacts_columns columns_wrap">
					<div class="column-1_3">
				<?php
			}

			if ( ( ! empty( $giardino_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_content front_page_section_contacts_content front_page_block_<?php echo ! empty( $giardino_content ) ? 'filled' : 'empty'; ?>">
				<?php
					echo wp_kses_post( $giardino_content );
				?>
				</div>
				<?php
			}

			if ( 'columns' == $giardino_layout && ( ! empty( $giardino_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div><div class="column-2_3">
				<?php
			}

			// Shortcode output
			$giardino_sc = giardino_get_theme_option( 'front_page_contacts_shortcode' );
			if ( ! empty( $giardino_sc ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_output front_page_section_contacts_output front_page_block_<?php echo ! empty( $giardino_sc ) ? 'filled' : 'empty'; ?>">
				<?php
					giardino_show_layout( do_shortcode( $giardino_sc ) );
				?>
				</div>
				<?php
			}

			if ( 'columns' == $giardino_layout && ( ! empty( $giardino_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>

		</div>
	</div>
</div>
