<?php
/**
 * The default template to display the content of the single post, page or attachment
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

$giardino_seo = giardino_is_on( giardino_get_theme_option( 'seo_snippets' ) );
$giardino_components = giardino_array_get_keys_by_value( giardino_get_theme_option( 'meta_parts' ) );
$giardino_counters   = giardino_array_get_keys_by_value( giardino_get_theme_option( 'counters' ) );
?>

<article id="post-<?php the_ID(); ?>" 
									<?php
									post_class(
										'post_item_single post_type_' . esc_attr( get_post_type() )
												. ' post_format_' . esc_attr( str_replace( 'post-format-', '', get_post_format() ) )
									);
									if ( $giardino_seo ) {
										?>
			itemscope="itemscope" 
			itemprop="articleBody" 
			itemtype="http://schema.org/<?php echo esc_attr( giardino_get_markup_schema() ); ?>" 
			itemid="<?php echo esc_url( get_the_permalink() ); ?>"
			content="<?php echo esc_attr( get_the_title() ); ?>"
										<?php
									}
									?>
>
<?php

	do_action( 'giardino_action_before_post_data' );

	// Structured data snippets
if ( $giardino_seo ) {
	get_template_part( apply_filters( 'giardino_filter_get_template_part', 'templates/seo' ) );
}

	// Featured image
if ( giardino_is_off( giardino_get_theme_option( 'hide_featured_on_single' ) )
			&& ! giardino_sc_layouts_showed( 'featured' )
			&& strpos( get_the_content(), '[trx_widget_banner]' ) === false ) {
	do_action( 'giardino_action_before_post_featured' );
	giardino_show_post_featured();
	do_action( 'giardino_action_after_post_featured' );
} elseif ( has_post_thumbnail() ) {
	?>
		<meta itemprop="image" itemtype="http://schema.org/ImageObject" content="<?php echo esc_url( wp_get_attachment_url( get_post_thumbnail_id() ) ); ?>">
		<?php
}

	// Title and post meta
if ( ( ! giardino_sc_layouts_showed( 'title' ) || ! giardino_sc_layouts_showed( 'postmeta' ) ) && ! in_array( get_post_format(), array( 'link', 'aside', 'status', 'quote' ) ) ) {
	do_action( 'giardino_action_before_post_title' );
	?>
		<div class="post_header post_header_single entry-header">
		<?php
		// Post title
		if ( ! giardino_sc_layouts_showed( 'title' ) ) {
			the_title( '<h3 class="post_title entry-title"' . ( $giardino_seo ? ' itemprop="headline"' : '' ) . '>', '</h3>' );
		}
		// Post meta
        ?>
            <div class="excerpt_meta">
                <div class="meta-left">
                    <?php

                    if ( ! empty( $giardino_components )) {
                        $cats = '';
                        $categories = 'categories';
                        $pos = strpos($giardino_components, $categories);
                        if ( $pos !==false ) {
                            $cats = get_post_type()=='post' ? get_the_category_list(' ') : apply_filters('giardino_filter_get_post_categories', '');
                            if (!empty($cats)) {
                                $cats = '<span class="post_meta_item post_categories">'.$cats.'</span>';
                            } else {
                                $cats = '';
                            }
                        }
                        giardino_show_layout($cats);
                    }
                    ?>
                </div>
                <div class="meta-right">
                    <?php
                    $vowels = array(",categories", "categories,", "categories");
                    $giardino_components = str_replace($vowels, "", $giardino_components);
                    if ( ! empty( $giardino_components )) {
                        giardino_show_post_meta(
                            apply_filters(
                                'giardino_filter_post_meta_args', array(
                                'components' => 'date,author',
                                'counters'   => false,
                                'seo'        => false,
                            ), 'excerpt', 1
                            )
                        );
                    }
                    ?>
                </div>
            </div>
		</div><!-- .post_header -->
		<?php
		do_action( 'giardino_action_after_post_title' );
}

	do_action( 'giardino_action_before_post_content' );

	// Post content
?>
	<div class="post_content post_content_single entry-content" itemprop="mainEntityOfPage">
		<?php
		the_content();

		do_action( 'giardino_action_before_post_pagination' );

		wp_link_pages(
			array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'giardino' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'giardino' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			)
		);

		// Taxonomies and share
		if ( is_single() && ! is_attachment() ) {

			do_action( 'giardino_action_before_post_meta' );

			// Post rating
			do_action(
				'trx_addons_action_post_rating', array(
					'class'                => 'single_post_rating',
					'rating_text_template' => esc_html__( 'Post rating: {{X}} from {{Y}} (according {{V}})', 'giardino' ),
				)
			);

			?>
			<div class="post_meta post_meta_single">
			<?php

				// Post taxonomies
				the_tags( '<span class="post_meta_item post_tags"><span class="post_meta_label">' . esc_html__( 'Tags', 'giardino' ) . '</span> ', ' ', '</span>' );

			?>
			<div class="footer_likes">
                <?php
                // Post meta
                if ( ! giardino_sc_layouts_showed( 'postmeta' ) && giardino_is_on( giardino_get_theme_option( 'show_post_meta' ) ) ) {
                    giardino_show_post_meta(
                        apply_filters(
                            'giardino_filter_post_meta_args', array(
                            'components' => giardino_array_get_keys_by_value( giardino_get_theme_option( 'meta_parts' ) ),
                            'counters'   => giardino_array_get_keys_by_value( giardino_get_theme_option( 'counters' ) ),
                            'seo'        => false,
                        ), 'single', 1
                        )
                    );
                }
                ?>
            </div>
			<?php
			// Share
			if ( giardino_is_on( giardino_get_theme_option( 'show_share_links' ) ) ) {
				giardino_show_share_links(
					array(
						'type'    => 'block',
						'caption' => '',
						'before'  => '<span class="post_meta_item post_share">',
						'after'   => '</span>',
					)
				);
			}
			?>
			</div>
			<?php

			do_action( 'giardino_action_after_post_meta' );
		}
		?>
	</div><!-- .entry-content -->

	<?php
	do_action( 'giardino_action_after_post_content' );

	// Author bio
	if ( giardino_get_theme_option( 'show_author_info' ) == 1 && is_single() && ! is_attachment() && get_the_author_meta( 'description' ) ) {
		do_action( 'giardino_action_before_post_author' );
		get_template_part( apply_filters( 'giardino_filter_get_template_part', 'templates/author-bio' ) );
		do_action( 'giardino_action_after_post_author' );
	}

	do_action( 'giardino_action_after_post_data' );
	?>
</article>
