<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

$giardino_columns     = max( 1, min( 3, count( get_option( 'sticky_posts' ) ) ) );
$giardino_post_format = get_post_format();
$giardino_post_format = empty( $giardino_post_format ) ? 'standard' : str_replace( 'post-format-', '', $giardino_post_format );
$giardino_animation   = giardino_get_theme_option( 'blog_animation' );

?><div class="column-1_<?php echo esc_attr( $giardino_columns ); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_' . esc_attr( $giardino_post_format ) ); ?>
	<?php echo ( ! giardino_is_off( $giardino_animation ) ? ' data-animation="' . esc_attr( giardino_get_animation_classes( $giardino_animation ) ) . '"' : '' ); ?>
	>

	<?php
	if ( is_sticky() && is_home() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	giardino_show_post_featured(
		array(
			'thumb_size' => giardino_get_thumb_size( 1 == $giardino_columns ? 'big' : ( 2 == $giardino_columns ? 'med' : 'avatar' ) ),
		)
	);

	if ( ! in_array( $giardino_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			giardino_show_post_meta( apply_filters( 'giardino_filter_post_meta_args', array(), 'sticky', $giardino_columns ) );
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div><?php

// div.column-1_X is a inline-block and new lines and spaces after it are forbidden
