<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage GIARDINO
 * @since GIARDINO 1.0
 */

$giardino_template_args = get_query_var( 'giardino_template_args' );
if ( is_array( $giardino_template_args ) ) {
	$giardino_columns    = empty( $giardino_template_args['columns'] ) ? 2 : max( 2, $giardino_template_args['columns'] );
	$giardino_blog_style = array( $giardino_template_args['type'], $giardino_columns );
} else {
	$giardino_blog_style = explode( '_', giardino_get_theme_option( 'blog_style' ) );
	$giardino_columns    = empty( $giardino_blog_style[1] ) ? 2 : max( 2, $giardino_blog_style[1] );
}
$giardino_post_format = get_post_format();
$giardino_post_format = empty( $giardino_post_format ) ? 'standard' : str_replace( 'post-format-', '', $giardino_post_format );
$giardino_animation   = giardino_get_theme_option( 'blog_animation' );

?><article id="post-<?php the_ID(); ?>" 
									<?php
									post_class(
										'post_item'
										. ' post_layout_portfolio'
										. ' post_layout_portfolio_' . esc_attr( $giardino_columns )
										. ' post_format_' . esc_attr( $giardino_post_format )
										. ( is_sticky() && ! is_paged() ? ' sticky' : '' )
										. ( ! empty( $giardino_template_args['slider'] ) ? ' slider-slide swiper-slide' : '' )
									);
									echo ( ! giardino_is_off( $giardino_animation ) && empty( $giardino_template_args['slider'] ) ? ' data-animation="' . esc_attr( giardino_get_animation_classes( $giardino_animation ) ) . '"' : '' );
									?>
	>
<?php

	// Sticky label
if ( is_sticky() && ! is_paged() ) {
	?>
		<span class="post_label label_sticky"></span>
		<?php
}

	$giardino_image_hover = ! empty( $giardino_template_args['hover'] ) && ! giardino_is_inherit( $giardino_template_args['hover'] )
								? $giardino_template_args['hover']
								: giardino_get_theme_option( 'image_hover' );


$counters = giardino_show_post_meta(
     array(
        'components' => 'counters',
        'counters'   => 'likes',
        'seo'        => false,
        'echo' => false
     )
);
	// Featured image
	giardino_show_post_featured(
		array(
			'singular'      => false,
			'hover'         => $giardino_image_hover,
			'no_links'      => ! empty( $giardino_template_args['no_links'] ),
			'thumb_size'    => giardino_get_thumb_size(
				strpos( giardino_get_theme_option( 'body_style' ), 'full' ) !== false || $giardino_columns < 3
								? 'masonry-big'
				: 'blogger'
			),
			'show_no_image' => true,
			'class'         => 'dots' == $giardino_image_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $giardino_image_hover ? '<div class="post_info">' . '<span>' . esc_html( get_the_title() ) . '</span>' . $counters  . '</div>' : '',
		)
	);
	?>
</article><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!